/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.pubkey;

import java.security.KeyPair;
import java.security.PublicKey;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesHolder;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.signature.SignatureFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class KeyPairIdentity
implements PublicKeyIdentity,
SignatureFactoriesHolder {
    private final KeyPair pair;
    private final List signatureFactories;

    public KeyPairIdentity(SignatureFactoriesManager signatureFactoriesManager, SignatureFactoriesManager signatureFactoriesManager2, KeyPair keyPair) {
        this.signatureFactories = Collections.unmodifiableList((List)ValidateUtils.checkNotNullAndNotEmpty(SignatureFactoriesManager.resolveSignatureFactories(signatureFactoriesManager, signatureFactoriesManager2), "No available signature factories", new Object[0]));
        this.pair = Objects.requireNonNull(keyPair, "No key pair");
    }

    @Override
    public KeyPair getKeyIdentity() {
        return this.pair;
    }

    @Override
    public List getSignatureFactories() {
        return this.signatureFactories;
    }

    @Override
    public Map.Entry sign(SessionContext sessionContext, String string, byte[] byArray) {
        NamedFactory namedFactory;
        KeyPair keyPair;
        if (GenericUtils.isEmpty(string)) {
            keyPair = this.getKeyIdentity();
            string = KeyUtils.getKeyType(keyPair.getPublic());
            namedFactory = SignatureFactory.resolveSignatureFactory(string, this.getSignatureFactories());
        } else {
            namedFactory = (NamedFactory)NamedResource.findByName(string, String.CASE_INSENSITIVE_ORDER, this.getSignatureFactories());
        }
        keyPair = namedFactory == null ? null : (Signature)namedFactory.create();
        ValidateUtils.checkNotNull((Object)keyPair, "No signer could be located for key type=%s", (Object)string);
        keyPair.initSigner(sessionContext, this.pair.getPrivate());
        keyPair.update(sessionContext, byArray);
        byte[] byArray2 = keyPair.sign(sessionContext);
        return new AbstractMap.SimpleImmutableEntry<String, byte[]>(namedFactory.getName(), byArray2);
    }

    public String toString() {
        KeyPair keyPair = this.getKeyIdentity();
        PublicKey publicKey = keyPair.getPublic();
        return this.getClass().getSimpleName() + " type=" + KeyUtils.getKeyType(publicKey) + ", factories=" + this.getSignatureFactoriesNameList() + ", fingerprint=" + KeyUtils.getFingerPrint(publicKey);
    }
}

