/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.pubkey;

import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;

public class KeyAgentIdentity
implements PublicKeyIdentity {
    private final SshAgent agent;
    private final KeyPair keyPair;
    private KeyPair resolvedPair;
    private final String comment;

    public KeyAgentIdentity(SshAgent sshAgent, PublicKey publicKey, String string) {
        this.agent = Objects.requireNonNull(sshAgent, "No signing agent");
        this.keyPair = new KeyPair(Objects.requireNonNull(publicKey, "No public key"), null);
        this.comment = string;
    }

    @Override
    public KeyPair getKeyIdentity() {
        if (this.resolvedPair == null) {
            this.resolvedPair = this.agent.resolveLocalIdentity(this.keyPair.getPublic());
        }
        return this.resolvedPair == null ? this.keyPair : this.resolvedPair;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public Map.Entry sign(SessionContext sessionContext, String string, byte[] byArray) {
        KeyPair keyPair = this.getKeyIdentity();
        return this.agent.sign(sessionContext, keyPair.getPublic(), string, byArray);
    }

    public String toString() {
        KeyPair keyPair = this.getKeyIdentity();
        PublicKey publicKey = keyPair.getPublic();
        return this.getClass().getSimpleName() + "[" + KeyUtils.getKeyType(publicKey) + "] fingerprint=" + KeyUtils.getFingerPrint(publicKey) + ", comment=" + this.getComment();
    }
}

