/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.password;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.client.auth.AbstractUserAuth;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.password.PasswordAuthenticationReporter;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.auth.UserAuthMethodFactory;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.core.CoreModuleProperties;

public class UserAuthPassword
extends AbstractUserAuth {
    public static final String NAME = "password";
    private Iterator passwords;
    private String current;
    private int maxAttempts;
    private int nOfAttempts;

    public UserAuthPassword() {
        super(NAME);
    }

    @Override
    public void init(ClientSession clientSession, String string) {
        super.init(clientSession, string);
        this.passwords = ClientSession.passwordIteratorOf(clientSession);
        this.maxAttempts = Math.max(1, (Integer)CoreModuleProperties.PASSWORD_PROMPTS.getRequired(clientSession));
    }

    @Override
    protected boolean sendAuthDataRequest(ClientSession clientSession, String string) {
        if (!UserAuthMethodFactory.isSecureAuthenticationTransport(clientSession)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendAuthDataRequest({})[{}] session is not secure", (Object)clientSession, (Object)string);
            }
            return false;
        }
        this.current = this.resolveAttemptedPassword(clientSession, string);
        if (this.current == null) {
            PasswordAuthenticationReporter passwordAuthenticationReporter;
            if (this.log.isDebugEnabled()) {
                this.log.debug("resolveAttemptedPassword({})[{}] no more passwords to send", (Object)clientSession, (Object)string);
            }
            if ((passwordAuthenticationReporter = clientSession.getPasswordAuthenticationReporter()) != null) {
                passwordAuthenticationReporter.signalAuthenticationExhausted(clientSession, string);
            }
            return false;
        }
        String string2 = clientSession.getUsername();
        int n2 = string2.length() + string.length() + GenericUtils.length(this.getName()) + this.current.length() + 32;
        Buffer buffer = clientSession.createBuffer((byte)50, n2);
        this.sendPassword(buffer, clientSession, this.current, this.current);
        return true;
    }

    protected String resolveAttemptedPassword(ClientSession clientSession, String string) {
        if (this.passwords != null && this.passwords.hasNext()) {
            return (String)this.passwords.next();
        }
        ++this.nOfAttempts;
        if (this.nOfAttempts > this.maxAttempts) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("resolveAttemptedPassword({})[{}] aborting after {} interactive attempts", new Object[]{clientSession, string, this.maxAttempts});
            }
            return null;
        }
        UserInteraction userInteraction = clientSession.getUserInteraction();
        if (userInteraction == null || !userInteraction.isInteractionAllowed(clientSession)) {
            return null;
        }
        return userInteraction.resolveAuthPasswordAttempt(clientSession);
    }

    @Override
    protected boolean processAuthDataRequest(ClientSession clientSession, String string, Buffer buffer) {
        String string2;
        boolean bl2;
        int n2 = buffer.getUByte();
        if (n2 != 60) {
            throw new IllegalStateException("processAuthDataRequest(" + clientSession + ")[" + string + "] received unknown packet: cmd=" + SshConstants.getCommandMessageName(n2));
        }
        boolean bl3 = this.log.isDebugEnabled();
        if (!UserAuthMethodFactory.isSecureAuthenticationTransport(clientSession)) {
            if (bl3) {
                this.log.debug("processAuthDataRequest({})[{}] session is not secure", (Object)clientSession, (Object)string);
            }
            return false;
        }
        if (!UserAuthMethodFactory.isDataIntegrityAuthenticationTransport(clientSession)) {
            if (bl3) {
                this.log.debug("processAuthDataRequest({})[{}] session is not validated via MAC", (Object)clientSession, (Object)string);
            }
            return false;
        }
        String string3 = buffer.getString();
        String string4 = buffer.getString();
        UserInteraction userInteraction = clientSession.getUserInteraction();
        try {
            bl2 = userInteraction != null && userInteraction.isInteractionAllowed(clientSession);
            string2 = bl2 ? userInteraction.getUpdatedPassword(clientSession, string3, string4) : null;
        }
        catch (Error error) {
            this.warn("processAuthDataRequest({})[{}] failed ({}) to consult interaction: {}", clientSession, string, error.getClass().getSimpleName(), error.getMessage(), error);
            throw new RuntimeSshException(error);
        }
        if (bl2) {
            if (GenericUtils.isEmpty(string2)) {
                if (bl3) {
                    this.log.debug("processAuthDataRequest({})[{}] No updated password for prompt={}, lang={}", new Object[]{clientSession, string, string3, string4});
                }
                return false;
            }
            this.sendPassword(buffer, clientSession, string2, string2);
            return true;
        }
        if (bl3) {
            this.log.debug("processAuthDataRequest({})[{}] no UI for password change request for prompt={}, lang={}", new Object[]{clientSession, string, string3, string4});
        }
        return false;
    }

    protected IoWriteFuture sendPassword(Buffer buffer, ClientSession clientSession, String string, String string2) {
        PasswordAuthenticationReporter passwordAuthenticationReporter;
        boolean bl2;
        String string3 = clientSession.getUsername();
        String string4 = this.getService();
        String string5 = this.getName();
        boolean bl3 = bl2 = !Objects.equals(string, string2);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendPassword({})[{}] send SSH_MSG_USERAUTH_REQUEST for {} - modified={}", new Object[]{clientSession, string4, string5, bl2});
        }
        int n2 = GenericUtils.length(string3) + GenericUtils.length(string4) + GenericUtils.length(string5) + GenericUtils.length(string) + (bl2 ? GenericUtils.length(string2) : 0) + 64;
        buffer = clientSession.createBuffer((byte)50, n2);
        buffer.putString(string3);
        buffer.putString(string4);
        buffer.putString(string5);
        buffer.putBoolean(bl2);
        buffer.putString(string);
        if (bl2) {
            buffer.putString(string2);
        }
        if ((passwordAuthenticationReporter = clientSession.getPasswordAuthenticationReporter()) != null) {
            passwordAuthenticationReporter.signalAuthenticationAttempt(clientSession, string4, string, bl2, string2);
        }
        return clientSession.writePacket(buffer);
    }

    @Override
    public void signalAuthMethodSuccess(ClientSession clientSession, String string, Buffer buffer) {
        PasswordAuthenticationReporter passwordAuthenticationReporter = clientSession.getPasswordAuthenticationReporter();
        if (passwordAuthenticationReporter != null) {
            passwordAuthenticationReporter.signalAuthenticationSuccess(clientSession, string, this.current);
        }
    }

    @Override
    public void signalAuthMethodFailure(ClientSession clientSession, String string, boolean bl2, List list, Buffer buffer) {
        PasswordAuthenticationReporter passwordAuthenticationReporter = clientSession.getPasswordAuthenticationReporter();
        if (passwordAuthenticationReporter != null) {
            passwordAuthenticationReporter.signalAuthenticationFailure(clientSession, string, this.current, bl2, list);
        }
    }
}

