/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.password;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.sshd.client.auth.password.PasswordIdentityProvider$1;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;

@FunctionalInterface
public interface PasswordIdentityProvider {
    public static final PasswordIdentityProvider EMPTY_PASSWORDS_PROVIDER = new PasswordIdentityProvider$1();

    public Iterable loadPasswords(SessionContext var1);

    public static Iterator iteratorOf(SessionContext sessionContext, PasswordIdentityProvider passwordIdentityProvider, PasswordIdentityProvider passwordIdentityProvider2) {
        return PasswordIdentityProvider.iteratorOf(sessionContext, PasswordIdentityProvider.resolvePasswordIdentityProvider(sessionContext, passwordIdentityProvider, passwordIdentityProvider2));
    }

    public static Iterator iteratorOf(SessionContext sessionContext, PasswordIdentityProvider passwordIdentityProvider) {
        return GenericUtils.iteratorOf(passwordIdentityProvider == null ? null : passwordIdentityProvider.loadPasswords(sessionContext));
    }

    public static PasswordIdentityProvider resolvePasswordIdentityProvider(SessionContext sessionContext, PasswordIdentityProvider passwordIdentityProvider, PasswordIdentityProvider passwordIdentityProvider2) {
        if (passwordIdentityProvider2 == null || passwordIdentityProvider == passwordIdentityProvider2) {
            return passwordIdentityProvider;
        }
        if (passwordIdentityProvider == null) {
            return passwordIdentityProvider2;
        }
        return PasswordIdentityProvider.multiProvider(sessionContext, passwordIdentityProvider, passwordIdentityProvider2);
    }

    public static PasswordIdentityProvider multiProvider(SessionContext sessionContext, PasswordIdentityProvider ... passwordIdentityProviderArray) {
        return PasswordIdentityProvider.multiProvider(sessionContext, GenericUtils.asList(passwordIdentityProviderArray));
    }

    public static PasswordIdentityProvider multiProvider(SessionContext sessionContext, Collection collection) {
        return GenericUtils.isEmpty(collection) ? EMPTY_PASSWORDS_PROVIDER : PasswordIdentityProvider.wrapPasswords(PasswordIdentityProvider.iterableOf(sessionContext, collection));
    }

    public static Iterable iterableOf(SessionContext sessionContext, Collection collection) {
        Iterable iterable = GenericUtils.wrapIterable(collection, passwordIdentityProvider -> () -> {
            try {
                return passwordIdentityProvider.loadPasswords(sessionContext);
            }
            catch (IOException | GeneralSecurityException exception) {
                throw new IllegalArgumentException(exception);
            }
        });
        return GenericUtils.multiIterableSuppliers(iterable);
    }

    public static PasswordIdentityProvider wrapPasswords(String ... stringArray) {
        return PasswordIdentityProvider.wrapPasswords(GenericUtils.asList(stringArray));
    }

    public static PasswordIdentityProvider wrapPasswords(Iterable iterable) {
        return iterable == null ? EMPTY_PASSWORDS_PROVIDER : sessionContext -> iterable;
    }
}

