/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.keyboard;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.client.auth.AbstractUserAuth;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.core.CoreModuleProperties;

public class UserAuthKeyboardInteractive
extends AbstractUserAuth {
    public static final String NAME = "keyboard-interactive";
    private final AtomicBoolean requestPending = new AtomicBoolean(false);
    private Iterator passwords;
    private int maxAttempts;
    private int nOfAttempts;
    private boolean wasChallenged;
    private boolean withUserInteraction;

    public UserAuthKeyboardInteractive() {
        super(NAME);
    }

    @Override
    public void init(ClientSession clientSession, String string) {
        super.init(clientSession, string);
        this.passwords = ClientSession.passwordIteratorOf(clientSession);
        this.maxAttempts = Math.max(1, (Integer)CoreModuleProperties.PASSWORD_PROMPTS.getRequired(clientSession));
        this.nOfAttempts = 0;
        this.wasChallenged = false;
        this.withUserInteraction = false;
    }

    @Override
    protected boolean sendAuthDataRequest(ClientSession clientSession, String string) {
        String string2 = this.getName();
        boolean bl2 = this.log.isDebugEnabled();
        if (this.requestPending.get()) {
            if (bl2) {
                this.log.debug("sendAuthDataRequest({})[{}] no reply for previous request for {}", new Object[]{clientSession, string, string2});
            }
            return false;
        }
        ++this.nOfAttempts;
        if (this.wasChallenged && !this.withUserInteraction) {
            --this.nOfAttempts;
        }
        this.wasChallenged = false;
        this.withUserInteraction = false;
        if (!this.verifyTrialsCount(clientSession, string, 50, this.nOfAttempts, this.maxAttempts)) {
            return false;
        }
        String string3 = clientSession.getUsername();
        String string4 = this.getExchangeLanguageTag(clientSession);
        String string5 = this.getExchangeSubMethods(clientSession);
        if (bl2) {
            this.log.debug("sendAuthDataRequest({})[{}] send SSH_MSG_USERAUTH_REQUEST for {}: lang={}, methods={}", new Object[]{clientSession, string, string2, string4, string5});
        }
        int n2 = string3.length() + string.length() + string2.length() + GenericUtils.length(string4) + GenericUtils.length(string5) + 64;
        Buffer buffer = clientSession.createBuffer((byte)50, n2);
        buffer.putString(string3);
        buffer.putString(string);
        buffer.putString(string2);
        buffer.putString(string4);
        buffer.putString(string5);
        this.requestPending.set(true);
        clientSession.writePacket(buffer);
        return true;
    }

    @Override
    protected boolean processAuthDataRequest(ClientSession clientSession, String string, Buffer buffer) {
        int n2 = buffer.getUByte();
        if (n2 != 60) {
            throw new IllegalStateException("processAuthDataRequest(" + clientSession + ")[" + string + "] received unknown packet: cmd=" + SshConstants.getCommandMessageName(n2));
        }
        this.requestPending.set(false);
        String string2 = buffer.getString();
        String string3 = buffer.getString();
        String string4 = buffer.getString();
        int n3 = buffer.getInt();
        if (n3 < 0 || n3 > 32768) {
            this.log.error("processAuthDataRequest({})[{}] illogical challenges count ({}) for name={}, instruction={}", new Object[]{clientSession, string, n3, string2, string3});
            throw new IndexOutOfBoundsException("Illogical challenges count: " + n3);
        }
        boolean bl2 = this.log.isDebugEnabled();
        if (bl2) {
            this.log.debug("processAuthDataRequest({})[{}] SSH_MSG_USERAUTH_INFO_REQUEST name={}, instruction={}, language={}, num-prompts={}", new Object[]{clientSession, string, string2, string3, string4, n3});
        }
        String[] stringArray = n3 > 0 ? new String[n3] : GenericUtils.EMPTY_STRING_ARRAY;
        boolean[] blArray = n3 > 0 ? new boolean[n3] : GenericUtils.EMPTY_BOOLEAN_ARRAY;
        boolean bl3 = this.log.isTraceEnabled();
        for (int i2 = 0; i2 < n3; ++i2) {
            stringArray[i2] = buffer.getString();
            blArray[i2] = buffer.getBoolean();
            if (!bl3) continue;
            this.log.trace("processAuthDataRequest({})[{}]({}) {}/{}: echo={}, prompt={}", new Object[]{clientSession, string, string2, i2 + 1, n3, blArray[i2], stringArray[i2]});
        }
        String[] stringArray2 = this.getUserResponses(string2, string3, string4, stringArray, blArray);
        if (stringArray2 == null) {
            if (bl2) {
                this.log.debug("processAuthDataRequest({})[{}] no responses for {}", new Object[]{clientSession, string, string2});
            }
            return false;
        }
        if (n3 != stringArray2.length) {
            this.log.warn("processAuthDataRequest({})[{}] Mismatched prompts ({}) vs. responses count ({})", new Object[]{clientSession, string, n3, stringArray2.length});
        }
        int n4 = stringArray2.length;
        buffer = clientSession.createBuffer((byte)61, n4 * 64 + 8);
        buffer.putUInt(n4);
        for (int i3 = 0; i3 < n4; ++i3) {
            String string5 = stringArray2[i3];
            if (bl3) {
                this.log.trace("processAuthDataRequest({})[{}] response #{}: {}", new Object[]{clientSession, string, i3 + 1, i3 < n3 && blArray[i3] ? string5 : "(hidden)"});
            }
            buffer.putString(string5);
        }
        clientSession.writePacket(buffer);
        return true;
    }

    protected String getExchangeLanguageTag(ClientSession clientSession) {
        return (String)CoreModuleProperties.INTERACTIVE_LANGUAGE_TAG.getRequired(clientSession);
    }

    protected String getExchangeSubMethods(ClientSession clientSession) {
        return (String)CoreModuleProperties.INTERACTIVE_SUBMETHODS.getRequired(clientSession);
    }

    protected String getCurrentPasswordCandidate() {
        if (this.passwords != null && this.passwords.hasNext()) {
            return (String)this.passwords.next();
        }
        return null;
    }

    protected boolean verifyTrialsCount(ClientSession clientSession, String string, int n2, int n3, int n4) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("verifyTrialsCount({})[{}] cmd={} - {} out of {}", new Object[]{clientSession, string, UserAuthKeyboardInteractive.getAuthCommandName(n2), n3, n4});
        }
        return n3 <= n4;
    }

    protected String[] getUserResponses(String string, String string2, String string3, String[] stringArray, boolean[] blArray) {
        Object object;
        ClientSession clientSession = this.getClientSession();
        int n2 = GenericUtils.length(stringArray);
        boolean bl2 = this.log.isDebugEnabled();
        if (n2 == 0) {
            if (bl2) {
                this.log.debug("getUserResponses({}) no prompts for interaction={}", (Object)clientSession, (Object)string);
            }
            return GenericUtils.EMPTY_STRING_ARRAY;
        }
        this.wasChallenged = true;
        if (PropertyResolverUtils.getBooleanProperty(clientSession, "user-interaction-auto-detect-password-prompt", true) && this.useCurrentPassword(clientSession, (String)(object = this.getCurrentPasswordCandidate()), string, string2, string3, stringArray, blArray)) {
            if (bl2) {
                this.log.debug("getUserResponses({}) use password candidate for interaction={}", (Object)clientSession, (Object)string);
            }
            return new String[]{object};
        }
        this.withUserInteraction = true;
        object = clientSession.getUserInteraction();
        try {
            if (object != null && object.isInteractionAllowed(clientSession)) {
                return object.interactive(clientSession, string, string2, string3, stringArray, blArray);
            }
        }
        catch (Error error) {
            this.warn("getUserResponses({}) failed ({}) to consult interaction: {}", clientSession, error.getClass().getSimpleName(), error.getMessage(), error);
            throw new RuntimeSshException(error);
        }
        if (bl2) {
            this.log.debug("getUserResponses({}) no user interaction for name={}", (Object)clientSession, (Object)string);
        }
        return null;
    }

    protected boolean useCurrentPassword(ClientSession clientSession, String string, String string2, String string3, String string4, String[] stringArray, boolean[] blArray) {
        String string5;
        int n2 = GenericUtils.length(stringArray);
        if (n2 != 1 || string == null || blArray[0]) {
            return false;
        }
        String string6 = GenericUtils.trimToEmpty(stringArray[0]);
        int n3 = UserInteraction.findPromptComponentLastPosition(string6 = string6.toLowerCase(), string5 = PropertyResolverUtils.getStringProperty(clientSession, "user-interaction-password-prompt", "password"));
        if (n3 < 0) {
            return false;
        }
        String string7 = PropertyResolverUtils.getStringProperty(clientSession, "user-interaction-check-password-delimiter", ":");
        if (PropertyResolverUtils.isNoneValue(string7)) {
            return true;
        }
        int n4 = UserInteraction.findPromptComponentLastPosition(string6, string7);
        return n4 >= n3;
    }

    public static String getAuthCommandName(int n2) {
        switch (n2) {
            case 50: {
                return "SSH_MSG_USERAUTH_REQUEST";
            }
            case 60: {
                return "SSH_MSG_USERAUTH_INFO_REQUEST";
            }
        }
        return SshConstants.getCommandMessageName(n2);
    }
}

