/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.hostbased;

import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sshd.client.auth.AbstractUserAuth;
import org.apache.sshd.client.auth.hostbased.HostBasedAuthenticationReporter;
import org.apache.sshd.client.auth.hostbased.HostKeyIdentityProvider;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class UserAuthHostBased
extends AbstractUserAuth
implements SignatureFactoriesManager {
    public static final String NAME = "hostbased";
    protected Iterator keys;
    protected Map.Entry keyInfo;
    protected final HostKeyIdentityProvider clientHostKeys;
    private List factories;
    private String clientUsername;
    private String clientHostname;

    public UserAuthHostBased(HostKeyIdentityProvider hostKeyIdentityProvider) {
        super(NAME);
        this.clientHostKeys = hostKeyIdentityProvider;
    }

    @Override
    public void init(ClientSession clientSession, String string) {
        super.init(clientSession, string);
        this.keys = HostKeyIdentityProvider.iteratorOf(clientSession, this.clientHostKeys);
    }

    @Override
    public List getSignatureFactories() {
        return this.factories;
    }

    @Override
    public void setSignatureFactories(List list) {
        this.factories = list;
    }

    public String getClientUsername() {
        return this.clientUsername;
    }

    public void setClientUsername(String string) {
        this.clientUsername = string;
    }

    public String getClientHostname() {
        return this.clientHostname;
    }

    public void setClientHostname(String string) {
        this.clientHostname = string;
    }

    @Override
    protected boolean sendAuthDataRequest(ClientSession clientSession, String string) {
        Object object2;
        String string2 = this.getName();
        boolean bl2 = this.log.isDebugEnabled();
        String string3 = this.resolveClientUsername(clientSession);
        String string4 = this.resolveClientHostname(clientSession);
        HostBasedAuthenticationReporter hostBasedAuthenticationReporter = clientSession.getHostBasedAuthenticationReporter();
        Map.Entry entry = this.keyInfo = this.keys != null && this.keys.hasNext() ? (Map.Entry)this.keys.next() : null;
        if (this.keyInfo == null) {
            if (bl2) {
                this.log.debug("sendAuthDataRequest({})[{}][{}] no more keys to send", new Object[]{clientSession, string, string2});
            }
            if (hostBasedAuthenticationReporter != null) {
                hostBasedAuthenticationReporter.signalAuthenticationExhausted(clientSession, string, string3, string4);
            }
            return false;
        }
        KeyPair keyPair = (KeyPair)this.keyInfo.getKey();
        PublicKey publicKey = keyPair.getPublic();
        String string5 = KeyUtils.getKeyType(publicKey);
        if (this.log.isTraceEnabled()) {
            this.log.trace("sendAuthDataRequest({})[{}][{}] current key details: type={}, fingerprint={}", new Object[]{clientSession, string, string2, string5, KeyUtils.getFingerPrint(publicKey)});
        }
        Collection collection = ValidateUtils.checkNotNullAndNotEmpty(SignatureFactoriesManager.resolveSignatureFactories(this, clientSession), "No signature factories for session=%s", clientSession);
        Signature signature = (Signature)ValidateUtils.checkNotNull((Object)((Signature)NamedFactory.create(collection, string5)), "No signer could be located for key type=%s", (Object)string5);
        byte[] byArray = clientSession.getSessionId();
        String string6 = clientSession.getUsername();
        if (bl2) {
            this.log.debug("sendAuthDataRequest({})[{}][{}] client={}@{}", new Object[]{clientSession, string, string2, string3, string4});
        }
        int n2 = byArray.length + string6.length() + string.length() + string3.length() + string4.length() + string5.length() + 256 + 64;
        Buffer buffer = clientSession.createBuffer((byte)50, n2);
        buffer.clear();
        buffer.putRawPublicKey(publicKey);
        Collection collection2 = (Collection)this.keyInfo.getValue();
        if (GenericUtils.size(collection2) > 0) {
            for (Object object2 : collection2) {
                buffer.putRawBytes(((Certificate)object2).getEncoded());
            }
        }
        signature.initSigner(clientSession, keyPair.getPrivate());
        Object object3 = buffer.getCompactData();
        buffer = clientSession.prepareBuffer((byte)50, BufferUtils.clear(buffer));
        buffer.putString(string6);
        buffer.putString(string);
        buffer.putString(string2);
        buffer.putString(string5);
        buffer.putBytes((byte[])object3);
        buffer.putString(string4);
        buffer.putString(string3);
        object2 = this.appendSignature(clientSession, string, string5, publicKey, (byte[])object3, string4, string3, signature, buffer);
        if (hostBasedAuthenticationReporter != null) {
            hostBasedAuthenticationReporter.signalAuthenticationAttempt(clientSession, string, keyPair, string4, string3, (byte[])object2);
        }
        clientSession.writePacket(buffer);
        return true;
    }

    protected byte[] appendSignature(ClientSession clientSession, String string, String string2, PublicKey publicKey, byte[] byArray, String string3, String string4, Signature signature, Buffer buffer) {
        byte[] byArray2 = clientSession.getSessionId();
        String string5 = clientSession.getUsername();
        String string6 = this.getName();
        int n2 = byArray2.length + string5.length() + string.length() + string6.length() + string2.length() + byArray.length + string3.length() + string4.length() + 256 + 64;
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(n2, false);
        byteArrayBuffer.putBytes(byArray2);
        ((Buffer)byteArrayBuffer).putByte((byte)50);
        byteArrayBuffer.putString(string5);
        byteArrayBuffer.putString(string);
        byteArrayBuffer.putString(string6);
        byteArrayBuffer.putString(string2);
        byteArrayBuffer.putBytes(byArray);
        byteArrayBuffer.putString(string3);
        byteArrayBuffer.putString(string4);
        signature.update(clientSession, ((Buffer)byteArrayBuffer).array(), ((Buffer)byteArrayBuffer).rpos(), byteArrayBuffer.available());
        byte[] byArray3 = signature.sign(clientSession);
        if (this.log.isTraceEnabled()) {
            this.log.trace("appendSignature({})[{}][{}] type={}, fingerprint={}, client={}@{}: signature={}", new Object[]{clientSession, string, string6, string2, KeyUtils.getFingerPrint(publicKey), string4, string3, BufferUtils.toHex(byArray3)});
        }
        byteArrayBuffer.clear();
        byteArrayBuffer.putString(string2);
        byteArrayBuffer.putBytes(byArray3);
        buffer.putBytes(((Buffer)byteArrayBuffer).array(), ((Buffer)byteArrayBuffer).rpos(), byteArrayBuffer.available());
        return byArray3;
    }

    @Override
    protected boolean processAuthDataRequest(ClientSession clientSession, String string, Buffer buffer) {
        int n2 = buffer.getUByte();
        throw new IllegalStateException("processAuthDataRequest(" + clientSession + ")[" + string + "] received unknown packet: cmd=" + SshConstants.getCommandMessageName(n2));
    }

    @Override
    public void signalAuthMethodSuccess(ClientSession clientSession, String string, Buffer buffer) {
        HostBasedAuthenticationReporter hostBasedAuthenticationReporter = clientSession.getHostBasedAuthenticationReporter();
        if (hostBasedAuthenticationReporter != null) {
            hostBasedAuthenticationReporter.signalAuthenticationSuccess(clientSession, string, this.keyInfo == null ? null : (KeyPair)this.keyInfo.getKey(), this.resolveClientHostname(clientSession), this.resolveClientUsername(clientSession));
        }
    }

    @Override
    public void signalAuthMethodFailure(ClientSession clientSession, String string, boolean bl2, List list, Buffer buffer) {
        HostBasedAuthenticationReporter hostBasedAuthenticationReporter = clientSession.getHostBasedAuthenticationReporter();
        if (hostBasedAuthenticationReporter != null) {
            hostBasedAuthenticationReporter.signalAuthenticationFailure(clientSession, string, this.keyInfo == null ? null : (KeyPair)this.keyInfo.getKey(), this.resolveClientHostname(clientSession), this.resolveClientUsername(clientSession), bl2, list);
        }
    }

    protected String resolveClientUsername(ClientSession clientSession) {
        String string = this.getClientUsername();
        return GenericUtils.isEmpty(string) ? OsUtils.getCurrentUser() : string;
    }

    protected String resolveClientHostname(ClientSession clientSession) {
        String string = this.getClientHostname();
        if (GenericUtils.isEmpty(string)) {
            string = SshdSocketAddress.toAddressString(SshdSocketAddress.getFirstExternalNetwork4Address());
        }
        return GenericUtils.isEmpty(string) ? "127.0.0.1" : string;
    }
}

