/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.client.auth.BuiltinUserAuthFactories$ParseResult;
import org.apache.sshd.client.auth.UserAuthFactory;
import org.apache.sshd.client.auth.hostbased.UserAuthHostBasedFactory;
import org.apache.sshd.client.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import org.apache.sshd.client.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyFactory;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.util.GenericUtils;

public enum BuiltinUserAuthFactories implements NamedFactory
{
    PASSWORD((UserAuthFactory)UserAuthPasswordFactory.INSTANCE),
    PUBLICKEY((UserAuthFactory)UserAuthPublicKeyFactory.INSTANCE),
    KBINTERACTIVE((UserAuthFactory)UserAuthKeyboardInteractiveFactory.INSTANCE),
    HOSTBASED((UserAuthFactory)UserAuthHostBasedFactory.INSTANCE);

    public static final Set VALUES;
    private final UserAuthFactory factory;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private BuiltinUserAuthFactories() {
        void var3_2;
        this.factory = (UserAuthFactory)Objects.requireNonNull(var3_2, "No delegate factory instance");
    }

    @Override
    public UserAuthFactory create() {
        return this.factory;
    }

    @Override
    public String getName() {
        return this.factory.getName();
    }

    public static UserAuthFactory fromFactoryName(String string) {
        Factory factory = (Factory)((Object)NamedResource.findByName(string, String.CASE_INSENSITIVE_ORDER, VALUES));
        if (factory == null) {
            return null;
        }
        return (UserAuthFactory)factory.create();
    }

    public static BuiltinUserAuthFactories$ParseResult parseFactoriesList(String string) {
        return BuiltinUserAuthFactories.parseFactoriesList(GenericUtils.split(string, ','));
    }

    public static BuiltinUserAuthFactories$ParseResult parseFactoriesList(String ... stringArray) {
        return BuiltinUserAuthFactories.parseFactoriesList(GenericUtils.isEmpty(stringArray) ? Collections.emptyList() : Arrays.asList(stringArray));
    }

    public static BuiltinUserAuthFactories$ParseResult parseFactoriesList(Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return BuiltinUserAuthFactories$ParseResult.EMPTY;
        }
        ArrayList<UserAuthFactory> arrayList = new ArrayList<UserAuthFactory>(collection.size());
        List list = Collections.emptyList();
        for (String string : collection) {
            UserAuthFactory userAuthFactory = BuiltinUserAuthFactories.resolveFactory(string);
            if (userAuthFactory != null) {
                arrayList.add(userAuthFactory);
                continue;
            }
            if (list.isEmpty()) {
                list = new ArrayList();
            }
            list.add(string);
        }
        return new BuiltinUserAuthFactories$ParseResult(arrayList, list);
    }

    public static UserAuthFactory resolveFactory(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        return BuiltinUserAuthFactories.fromFactoryName(string);
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinUserAuthFactories.class));
    }
}

