/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth;

import java.util.Objects;
import org.apache.sshd.client.auth.UserAuth;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractUserAuth
extends AbstractLoggingBean
implements UserAuth {
    private final String name;
    private ClientSession clientSession;
    private String service;
    private boolean cancellable;

    protected AbstractUserAuth(String string) {
        this.name = ValidateUtils.checkNotNullAndNotEmpty(string, "No name");
    }

    @Override
    public ClientSession getClientSession() {
        return this.clientSession;
    }

    @Override
    public ClientSession getSession() {
        return this.getClientSession();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public String getService() {
        return this.service;
    }

    @Override
    public boolean isCancellable() {
        return this.cancellable;
    }

    protected void setCancellable(boolean bl2) {
        this.cancellable = bl2;
    }

    @Override
    public void init(ClientSession clientSession, String string) {
        this.clientSession = Objects.requireNonNull(clientSession, "No client session");
        this.service = ValidateUtils.checkNotNullAndNotEmpty(string, "No service");
    }

    @Override
    public boolean process(Buffer buffer) {
        ClientSession clientSession = this.getClientSession();
        String string = this.getService();
        if (buffer == null) {
            return this.sendAuthDataRequest(clientSession, string);
        }
        return this.processAuthDataRequest(clientSession, string, buffer);
    }

    protected abstract boolean sendAuthDataRequest(ClientSession var1, String var2);

    protected abstract boolean processAuthDataRequest(ClientSession var1, String var2, Buffer var3);

    @Override
    public void destroy() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("destroy({})[{}]", (Object)this.getClientSession(), (Object)this.getService());
        }
    }

    public String toString() {
        return this.getName() + ": " + this.getSession() + "[" + this.getService() + "]";
    }
}

