/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.channels.UnsupportedAddressTypeException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.SshClient$1;
import org.apache.sshd.client.SshClient$2;
import org.apache.sshd.client.auth.AuthenticationIdentitiesProvider;
import org.apache.sshd.client.auth.hostbased.HostBasedAuthenticationReporter;
import org.apache.sshd.client.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.password.PasswordAuthenticationReporter;
import org.apache.sshd.client.auth.password.PasswordIdentityProvider;
import org.apache.sshd.client.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.client.auth.pubkey.PublicKeyAuthenticationReporter;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKey;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyFactory;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.client.config.keys.ClientIdentity;
import org.apache.sshd.client.config.keys.ClientIdentityLoader;
import org.apache.sshd.client.config.keys.DefaultClientIdentitiesWatcher;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.DefaultConnectFuture;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.AbstractClientSession;
import org.apache.sshd.client.session.ClientConnectionServiceFactory;
import org.apache.sshd.client.session.ClientProxyConnector;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientUserAuthServiceFactory;
import org.apache.sshd.client.session.SessionFactory;
import org.apache.sshd.client.session.forward.ExplicitPortForwardingTracker;
import org.apache.sshd.client.simple.AbstractSimpleClientSessionCreator;
import org.apache.sshd.client.simple.SimpleClient;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.FilePasswordProviderManager;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.future.CancelFuture;
import org.apache.sshd.common.future.Cancellable;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.keyprovider.AbstractResourceKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.keyprovider.MultiKeyIdentityProvider;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.functors.UnaryEquator;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.core.CoreModuleProperties;
import org.slf4j.Logger;

public class SshClient
extends AbstractFactoryManager
implements ClientFactoryManager,
Closeable {
    public static final Factory DEFAULT_SSH_CLIENT_FACTORY = SshClient::new;
    public static final List DEFAULT_USER_AUTH_FACTORIES = Collections.unmodifiableList(Arrays.asList(UserAuthPublicKeyFactory.INSTANCE, UserAuthKeyboardInteractiveFactory.INSTANCE, UserAuthPasswordFactory.INSTANCE));
    public static final List DEFAULT_SERVICE_FACTORIES = Collections.unmodifiableList(Arrays.asList(ClientUserAuthServiceFactory.INSTANCE, ClientConnectionServiceFactory.INSTANCE));
    protected IoConnector connector;
    protected SessionFactory sessionFactory;
    protected List userAuthFactories;
    private ClientProxyConnector proxyConnector;
    private ServerKeyVerifier serverKeyVerifier;
    private HostConfigEntryResolver hostConfigEntryResolver;
    private ClientIdentityLoader clientIdentityLoader;
    private KeyIdentityProvider keyIdentityProvider;
    private PublicKeyAuthenticationReporter publicKeyAuthenticationReporter;
    private FilePasswordProvider filePasswordProvider;
    private PasswordIdentityProvider passwordIdentityProvider;
    private PasswordAuthenticationReporter passwordAuthenticationReporter;
    private HostBasedAuthenticationReporter hostBasedAuthenticationReporter;
    private UserInteraction userInteraction;
    private final List identities = new CopyOnWriteArrayList();
    private final AuthenticationIdentitiesProvider identitiesProvider;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public SshClient() {
        this.identitiesProvider = AuthenticationIdentitiesProvider.wrapIdentities(this.identities);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public ClientProxyConnector getClientProxyConnector() {
        return this.proxyConnector;
    }

    @Override
    public void setClientProxyConnector(ClientProxyConnector clientProxyConnector) {
        this.proxyConnector = clientProxyConnector;
    }

    @Override
    public ServerKeyVerifier getServerKeyVerifier() {
        return this.serverKeyVerifier;
    }

    @Override
    public void setServerKeyVerifier(ServerKeyVerifier serverKeyVerifier) {
        this.serverKeyVerifier = Objects.requireNonNull(serverKeyVerifier, "No server key verifier");
    }

    @Override
    public HostConfigEntryResolver getHostConfigEntryResolver() {
        return this.hostConfigEntryResolver;
    }

    @Override
    public void setHostConfigEntryResolver(HostConfigEntryResolver hostConfigEntryResolver) {
        this.hostConfigEntryResolver = Objects.requireNonNull(hostConfigEntryResolver, "No host configuration entry resolver");
    }

    @Override
    public FilePasswordProvider getFilePasswordProvider() {
        return this.filePasswordProvider;
    }

    @Override
    public void setFilePasswordProvider(FilePasswordProvider filePasswordProvider) {
        this.filePasswordProvider = Objects.requireNonNull(filePasswordProvider, "No file password provider");
    }

    @Override
    public ClientIdentityLoader getClientIdentityLoader() {
        return this.clientIdentityLoader;
    }

    @Override
    public void setClientIdentityLoader(ClientIdentityLoader clientIdentityLoader) {
        this.clientIdentityLoader = Objects.requireNonNull(clientIdentityLoader, "No client identity loader");
    }

    @Override
    public UserInteraction getUserInteraction() {
        return this.userInteraction;
    }

    @Override
    public void setUserInteraction(UserInteraction userInteraction) {
        this.userInteraction = userInteraction;
    }

    @Override
    public PasswordAuthenticationReporter getPasswordAuthenticationReporter() {
        return this.passwordAuthenticationReporter;
    }

    @Override
    public void setPasswordAuthenticationReporter(PasswordAuthenticationReporter passwordAuthenticationReporter) {
        this.passwordAuthenticationReporter = passwordAuthenticationReporter;
    }

    @Override
    public HostBasedAuthenticationReporter getHostBasedAuthenticationReporter() {
        return this.hostBasedAuthenticationReporter;
    }

    @Override
    public void setHostBasedAuthenticationReporter(HostBasedAuthenticationReporter hostBasedAuthenticationReporter) {
        this.hostBasedAuthenticationReporter = hostBasedAuthenticationReporter;
    }

    @Override
    public List getUserAuthFactories() {
        return this.userAuthFactories;
    }

    @Override
    public void setUserAuthFactories(List list) {
        this.userAuthFactories = (List)ValidateUtils.checkNotNullAndNotEmpty(list, "No user auth factories", new Object[0]);
    }

    @Override
    public AuthenticationIdentitiesProvider getRegisteredIdentities() {
        return this.identitiesProvider;
    }

    @Override
    public PasswordIdentityProvider getPasswordIdentityProvider() {
        return this.passwordIdentityProvider;
    }

    @Override
    public void setPasswordIdentityProvider(PasswordIdentityProvider passwordIdentityProvider) {
        this.passwordIdentityProvider = passwordIdentityProvider;
    }

    @Override
    public void addPasswordIdentity(String string) {
        ValidateUtils.checkTrue(string != null && !string.isEmpty(), "No password provided");
        this.identities.add(string);
        if (this.log.isDebugEnabled()) {
            this.log.debug("addPasswordIdentity({}) {}", (Object)this, (Object)KeyUtils.getFingerPrint(string));
        }
    }

    @Override
    public String removePasswordIdentity(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        int n2 = AuthenticationIdentitiesProvider.findIdentityIndex(this.identities, AuthenticationIdentitiesProvider.PASSWORD_IDENTITY_COMPARATOR, string);
        if (n2 >= 0) {
            return (String)this.identities.remove(n2);
        }
        return null;
    }

    @Override
    public void addPublicKeyIdentity(KeyPair keyPair) {
        Objects.requireNonNull(keyPair, "No key-pair to add");
        Objects.requireNonNull(keyPair.getPublic(), "No public key");
        Objects.requireNonNull(keyPair.getPrivate(), "No private key");
        this.identities.add(keyPair);
        if (this.log.isDebugEnabled()) {
            this.log.debug("addPublicKeyIdentity({}) {}", (Object)this, (Object)KeyUtils.getFingerPrint(keyPair.getPublic()));
        }
    }

    @Override
    public KeyPair removePublicKeyIdentity(KeyPair keyPair) {
        if (keyPair == null) {
            return null;
        }
        int n2 = AuthenticationIdentitiesProvider.findIdentityIndex(this.identities, AuthenticationIdentitiesProvider.KEYPAIR_IDENTITY_COMPARATOR, keyPair);
        if (n2 >= 0) {
            return (KeyPair)this.identities.remove(n2);
        }
        return null;
    }

    @Override
    public KeyIdentityProvider getKeyIdentityProvider() {
        return this.keyIdentityProvider;
    }

    @Override
    public void setKeyIdentityProvider(KeyIdentityProvider keyIdentityProvider) {
        this.keyIdentityProvider = keyIdentityProvider;
    }

    @Override
    public PublicKeyAuthenticationReporter getPublicKeyAuthenticationReporter() {
        return this.publicKeyAuthenticationReporter;
    }

    @Override
    public void setPublicKeyAuthenticationReporter(PublicKeyAuthenticationReporter publicKeyAuthenticationReporter) {
        this.publicKeyAuthenticationReporter = publicKeyAuthenticationReporter;
    }

    @Override
    protected void checkConfig() {
        List list;
        Object object;
        super.checkConfig();
        Objects.requireNonNull(this.getForwarderFactory(), "ForwarderFactory not set");
        Objects.requireNonNull(this.getServerKeyVerifier(), "ServerKeyVerifier not set");
        Objects.requireNonNull(this.getHostConfigEntryResolver(), "HostConfigEntryResolver not set");
        Objects.requireNonNull(this.getClientIdentityLoader(), "ClientIdentityLoader not set");
        Objects.requireNonNull(this.getFilePasswordProvider(), "FilePasswordProvider not set");
        KeyIdentityProvider keyIdentityProvider = this.getKeyIdentityProvider();
        if (keyIdentityProvider == null) {
            object = new DefaultClientIdentitiesWatcher(this::getClientIdentityLoader, this::getFilePasswordProvider);
            this.setKeyIdentityProvider((KeyIdentityProvider)object);
        }
        if ((object = this.getAgentFactory()) != null && !GenericUtils.isEmpty(list = object.getChannelForwardingFactories(this))) {
            ArrayList arrayList = this.getChannelFactories();
            if (GenericUtils.isEmpty(arrayList)) {
                arrayList = list;
            } else {
                ArrayList arrayList2 = new ArrayList(arrayList.size() + list.size());
                arrayList2.addAll(arrayList);
                arrayList2.addAll(list);
                arrayList = arrayList2;
            }
            this.setChannelFactories(arrayList);
        }
        if (GenericUtils.isEmpty(this.getServiceFactories())) {
            this.setServiceFactories(DEFAULT_SERVICE_FACTORIES);
        }
        if (GenericUtils.isEmpty(this.getUserAuthFactories())) {
            this.setUserAuthFactories(DEFAULT_USER_AUTH_FACTORIES);
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public void start() {
        if (this.isClosed()) {
            throw new IllegalStateException("Can not start the client again");
        }
        if (this.isStarted()) {
            return;
        }
        this.checkConfig();
        if (this.sessionFactory == null) {
            this.sessionFactory = this.createSessionFactory();
        }
        this.setupSessionTimeout(this.sessionFactory);
        this.connector = this.createConnector();
        this.started.set(true);
    }

    public void stop() {
        if (!this.started.getAndSet(false)) {
            return;
        }
        try {
            Duration duration = (Duration)CoreModuleProperties.STOP_WAIT_TIME.getRequired(this);
            boolean bl2 = this.close(true).await(duration);
            if (!bl2) {
                throw new SocketTimeoutException("Failed to receive closure confirmation within " + duration + " millis");
            }
        }
        catch (IOException iOException) {
            this.warn("{} while stopping client: {}", iOException.getClass().getSimpleName(), iOException.getMessage(), iOException);
        }
        finally {
            this.clearAttributes();
        }
    }

    public void open() {
        this.start();
    }

    @Override
    protected Closeable getInnerCloseable() {
        String string = this.toString();
        return this.builder().run(string, () -> this.removeSessionTimeout(this.sessionFactory)).sequential(this.connector, this.ioServiceFactory).run(string, () -> {
            this.connector = null;
            this.ioServiceFactory = null;
            if (this.shutdownExecutor && this.executor != null && !this.executor.isShutdown()) {
                try {
                    this.executor.shutdownNow();
                }
                finally {
                    this.executor = null;
                }
            }
        }).build();
    }

    @Override
    public ConnectFuture connect(String string) {
        Objects.requireNonNull(string, "No uri address");
        URI uRI = URI.create(string.contains("//") ? string : "ssh://" + string);
        if (GenericUtils.isNotEmpty(uRI.getScheme()) && !"ssh".equals(uRI.getScheme())) {
            throw new IllegalArgumentException("Unsupported scheme for uri: " + uRI);
        }
        String string2 = uRI.getHost();
        int n2 = uRI.getPort();
        String string3 = uRI.getUserInfo();
        return this.connect(string3, string2, n2);
    }

    @Override
    public ConnectFuture connect(String string, SocketAddress socketAddress, AttributeRepository attributeRepository, SocketAddress socketAddress2) {
        Objects.requireNonNull(socketAddress, "No target address");
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        String string2 = ValidateUtils.checkNotNullAndNotEmpty(inetSocketAddress.getHostString(), "No host");
        int n2 = inetSocketAddress.getPort();
        ValidateUtils.checkTrue(n2 > 0, "Invalid port: %d", n2);
        return this.connect(string, string2, n2, attributeRepository, socketAddress2);
    }

    @Override
    public ConnectFuture connect(String string, String string2, int n2, AttributeRepository attributeRepository, SocketAddress socketAddress) {
        HostConfigEntry hostConfigEntry = this.resolveHost(string, string2, n2, attributeRepository, socketAddress);
        return this.connect(hostConfigEntry, attributeRepository, socketAddress);
    }

    @Override
    public ConnectFuture connect(HostConfigEntry hostConfigEntry, AttributeRepository attributeRepository, SocketAddress socketAddress) {
        List list = this.parseProxyJumps(hostConfigEntry.getProxyJump(), attributeRepository);
        return this.doConnect(hostConfigEntry, list, attributeRepository, socketAddress);
    }

    protected ConnectFuture doConnect(HostConfigEntry hostConfigEntry, List list, AttributeRepository attributeRepository, SocketAddress socketAddress) {
        Objects.requireNonNull(hostConfigEntry, "No host configuration");
        String string2 = ValidateUtils.checkNotNullAndNotEmpty(hostConfigEntry.getHostName(), "No target host");
        int n2 = hostConfigEntry.getPort();
        ValidateUtils.checkTrue(n2 > 0, "Invalid port: %d", n2);
        Collection collection = hostConfigEntry.getIdentities();
        Collection collection2 = GenericUtils.stream(collection).map(string -> Paths.get(string, new String[0])).map(PathResource::new).collect(Collectors.toCollection(() -> new ArrayList(collection.size())));
        KeyIdentityProvider keyIdentityProvider = this.preloadClientIdentities(collection2);
        String string3 = hostConfigEntry.getUsername();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(hostConfigEntry.getHostName(), hostConfigEntry.getPort());
        if (GenericUtils.isNotEmpty(list)) {
            DefaultConnectFuture defaultConnectFuture = new DefaultConnectFuture(string3 + "@" + inetSocketAddress, null);
            HostConfigEntry hostConfigEntry2 = (HostConfigEntry)list.remove(0);
            ConnectFuture connectFuture3 = this.doConnect(hostConfigEntry2, list, attributeRepository, null);
            AtomicReference<ConnectFuture> atomicReference = new AtomicReference<ConnectFuture>(connectFuture3);
            defaultConnectFuture.addListener(connectFuture -> {
                if (!connectFuture.isCanceled()) {
                    return;
                }
                Cancellable cancellable = (Cancellable)atomicReference.get();
                if (cancellable == null) {
                    return;
                }
                CancelFuture cancelFuture2 = cancellable.cancel();
                if (cancelFuture2 == null) {
                    return;
                }
                cancelFuture2.addListener(cancelFuture -> {
                    if (cancelFuture.isDone()) {
                        connectFuture.getCancellation().setCanceled();
                    }
                });
            });
            connectFuture3.addListener(connectFuture2 -> {
                if (connectFuture2.isConnected()) {
                    ClientSession clientSession = connectFuture2.getClientSession();
                    try {
                        if (defaultConnectFuture.isCanceled()) {
                            clientSession.close(true);
                        }
                        AuthFuture authFuture2 = clientSession.auth();
                        atomicReference.set((ConnectFuture)((Object)authFuture2));
                        authFuture2.addListener(authFuture -> {
                            if (authFuture.isSuccess()) {
                                try {
                                    SshdSocketAddress sshdSocketAddress = new SshdSocketAddress(hostConfigEntry.getHostName(), hostConfigEntry.getPort());
                                    ExplicitPortForwardingTracker explicitPortForwardingTracker = clientSession.createLocalPortForwardingTracker(SshdSocketAddress.LOCALHOST_ADDRESS, sshdSocketAddress);
                                    SshdSocketAddress sshdSocketAddress2 = explicitPortForwardingTracker.getBoundAddress();
                                    ConnectFuture connectFuture3 = this.doConnect(hostConfigEntry.getUsername(), sshdSocketAddress2.toInetSocketAddress(), attributeRepository, socketAddress, keyIdentityProvider, hostConfigEntry);
                                    atomicReference.set(connectFuture3);
                                    if (defaultConnectFuture.isCanceled()) {
                                        connectFuture3.cancel();
                                    }
                                    connectFuture3.addListener(connectFuture2 -> {
                                        if (connectFuture2.isConnected()) {
                                            ClientSession clientSession2 = connectFuture2.getClientSession();
                                            clientSession2.setAttribute(TARGET_SERVER, sshdSocketAddress);
                                            defaultConnectFuture.setSession(clientSession2);
                                            clientSession.addCloseFutureListener(closeFuture -> clientSession2.close(true));
                                            clientSession2.addCloseFutureListener(closeFuture -> clientSession.close(true));
                                        } else {
                                            clientSession.close(true);
                                            defaultConnectFuture.setException(connectFuture2.getException());
                                        }
                                    });
                                }
                                catch (IOException iOException) {
                                    clientSession.close(true);
                                    defaultConnectFuture.setException(iOException);
                                }
                            } else {
                                clientSession.close(true);
                                defaultConnectFuture.setException(authFuture.getException());
                            }
                        });
                    }
                    catch (IOException iOException) {
                        clientSession.close(true);
                        defaultConnectFuture.setException(iOException);
                    }
                } else {
                    defaultConnectFuture.setException(connectFuture2.getException());
                }
            });
            return defaultConnectFuture;
        }
        return this.doConnect(hostConfigEntry.getUsername(), new InetSocketAddress(string2, n2), attributeRepository, socketAddress, keyIdentityProvider, hostConfigEntry);
    }

    protected ConnectFuture doConnect(String string, SocketAddress socketAddress, AttributeRepository attributeRepository, SocketAddress socketAddress2, KeyIdentityProvider keyIdentityProvider, HostConfigEntry hostConfigEntry) {
        if (this.connector == null) {
            throw new IllegalStateException("SshClient not started. Please call start() method before connecting to a server");
        }
        DefaultConnectFuture defaultConnectFuture = new DefaultConnectFuture(string + "@" + socketAddress, null);
        SshFutureListener sshFutureListener = this.createConnectCompletionListener(defaultConnectFuture, string, socketAddress, keyIdentityProvider, hostConfigEntry);
        IoConnectFuture ioConnectFuture = this.connector.connect(socketAddress, attributeRepository, socketAddress2);
        defaultConnectFuture.addListener(connectFuture -> {
            if (connectFuture.isCanceled()) {
                ioConnectFuture.cancel();
            }
        });
        ioConnectFuture.addListener(sshFutureListener);
        return defaultConnectFuture;
    }

    protected List parseProxyJumps(String string, AttributeRepository attributeRepository) {
        ArrayList<HostConfigEntry> arrayList = new ArrayList<HostConfigEntry>();
        for (String string2 : GenericUtils.split(string, ',')) {
            String string3 = string2.trim();
            URI uRI = URI.create(string3.contains("//") ? string3 : "ssh://" + string3);
            if (GenericUtils.isNotEmpty(uRI.getScheme()) && !"ssh".equals(uRI.getScheme())) {
                throw new IllegalArgumentException("Unsupported scheme for proxy jump: " + string2);
            }
            String string4 = uRI.getHost();
            int n2 = uRI.getPort();
            String string5 = uRI.getUserInfo();
            HostConfigEntry hostConfigEntry = this.resolveHost(string5, string4, n2, attributeRepository, null);
            arrayList.add(hostConfigEntry);
        }
        return arrayList;
    }

    protected HostConfigEntry resolveHost(String string, String string2, int n2, AttributeRepository attributeRepository, SocketAddress socketAddress) {
        HostConfigEntryResolver hostConfigEntryResolver = this.getHostConfigEntryResolver();
        HostConfigEntry hostConfigEntry = hostConfigEntryResolver.resolveEffectiveHost(string2, n2, socketAddress, string, null, attributeRepository);
        if (hostConfigEntry == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("connect({}@{}:{}) no overrides", new Object[]{string, string2, n2});
            }
            hostConfigEntry = SshdSocketAddress.isIPv6Address(string2) ? new HostConfigEntry("", string2, n2, string, null) : new HostConfigEntry(string2, string2, n2, string, null);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("connect({}@{}:{}) effective: {}", new Object[]{string, string2, n2, hostConfigEntry});
        }
        return hostConfigEntry;
    }

    protected KeyIdentityProvider preloadClientIdentities(Collection collection) {
        return GenericUtils.isEmpty(collection) ? KeyIdentityProvider.EMPTY_KEYS_PROVIDER : ClientIdentityLoader.asKeyIdentityProvider(Objects.requireNonNull(this.getClientIdentityLoader(), "No ClientIdentityLoader"), collection, this.getFilePasswordProvider(), (Boolean)CoreModuleProperties.IGNORE_INVALID_IDENTITIES.getRequired(this));
    }

    protected SshFutureListener createConnectCompletionListener(ConnectFuture connectFuture, String string, SocketAddress socketAddress, KeyIdentityProvider keyIdentityProvider, HostConfigEntry hostConfigEntry) {
        return new SshClient$1(this, connectFuture, string, socketAddress, keyIdentityProvider, hostConfigEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onConnectOperationComplete(IoSession ioSession, ConnectFuture connectFuture, String string, SocketAddress socketAddress, KeyIdentityProvider keyIdentityProvider, HostConfigEntry hostConfigEntry) {
        AbstractClientSession abstractClientSession = (AbstractClientSession)AbstractSession.getSession(ioSession);
        abstractClientSession.setUsername(string);
        abstractClientSession.setConnectAddress(socketAddress);
        boolean bl2 = !hostConfigEntry.isIdentitiesOnly();
        abstractClientSession.setAttribute(UserAuthPublicKey.USE_DEFAULT_IDENTITIES, bl2);
        String string2 = hostConfigEntry.getProperty("IdentityAgent");
        abstractClientSession.setAttribute(UserAuthPublicKey.IDENTITY_AGENT, string2 == null ? "" : string2);
        if (bl2) {
            this.setupDefaultSessionIdentities(abstractClientSession, keyIdentityProvider);
        } else if (keyIdentityProvider == null) {
            abstractClientSession.setKeyIdentityProvider(KeyIdentityProvider.EMPTY_KEYS_PROVIDER);
        } else {
            abstractClientSession.setKeyIdentityProvider(this.ensureFilePasswordProvider(keyIdentityProvider));
        }
        connectFuture.setSession(abstractClientSession);
        if (abstractClientSession != connectFuture.getSession()) {
            try {
                abstractClientSession.close(true);
            }
            finally {
                CancelFuture cancelFuture = connectFuture.cancel();
                if (cancelFuture != null) {
                    cancelFuture.setCanceled();
                }
            }
        }
    }

    protected KeyIdentityProvider ensureFilePasswordProvider(KeyIdentityProvider keyIdentityProvider) {
        if (keyIdentityProvider instanceof AbstractResourceKeyPairProvider) {
            FilePasswordProvider filePasswordProvider;
            AbstractResourceKeyPairProvider abstractResourceKeyPairProvider = (AbstractResourceKeyPairProvider)keyIdentityProvider;
            if (abstractResourceKeyPairProvider.getPasswordFinder() == null && (filePasswordProvider = this.getFilePasswordProvider()) != null) {
                abstractResourceKeyPairProvider.setPasswordFinder(filePasswordProvider);
            }
        } else if (keyIdentityProvider instanceof FilePasswordProviderManager) {
            FilePasswordProvider filePasswordProvider;
            FilePasswordProviderManager filePasswordProviderManager = (FilePasswordProviderManager)((Object)keyIdentityProvider);
            if (filePasswordProviderManager.getFilePasswordProvider() == null && (filePasswordProvider = this.getFilePasswordProvider()) != null) {
                filePasswordProviderManager.setFilePasswordProvider(filePasswordProvider);
            }
        } else if (keyIdentityProvider instanceof MultiKeyIdentityProvider) {
            MultiKeyIdentityProvider multiKeyIdentityProvider = (MultiKeyIdentityProvider)keyIdentityProvider;
            multiKeyIdentityProvider.getProviders().forEach(this::ensureFilePasswordProvider);
        }
        return keyIdentityProvider;
    }

    protected void setupDefaultSessionIdentities(ClientSession clientSession, KeyIdentityProvider keyIdentityProvider) {
        PasswordIdentityProvider passwordIdentityProvider;
        PasswordIdentityProvider passwordIdentityProvider2;
        KeyIdentityProvider keyIdentityProvider2;
        boolean bl2 = this.log.isDebugEnabled();
        KeyIdentityProvider keyIdentityProvider3 = clientSession.getKeyIdentityProvider();
        if (UnaryEquator.isSameReference(keyIdentityProvider3, keyIdentityProvider2 = this.getKeyIdentityProvider()) && bl2) {
            this.log.debug("setupDefaultSessionIdentities({}) key identity provider override in session listener", (Object)clientSession);
        }
        KeyIdentityProvider keyIdentityProvider4 = KeyIdentityProvider.resolveKeyIdentityProvider(keyIdentityProvider, keyIdentityProvider3);
        if (!UnaryEquator.isSameReference(keyIdentityProvider3, keyIdentityProvider4 = this.ensureFilePasswordProvider(keyIdentityProvider4))) {
            if (bl2) {
                this.log.debug("setupDefaultSessionIdentities({}) key identity provider enhanced", (Object)clientSession);
            }
            clientSession.setKeyIdentityProvider(keyIdentityProvider4);
        }
        if (!UnaryEquator.isSameReference(passwordIdentityProvider2 = clientSession.getPasswordIdentityProvider(), passwordIdentityProvider = this.getPasswordIdentityProvider()) && bl2) {
            this.log.debug("setupDefaultSessionIdentities({}) password provider override", (Object)clientSession);
        }
        AuthenticationIdentitiesProvider authenticationIdentitiesProvider = this.getRegisteredIdentities();
        boolean bl3 = this.log.isTraceEnabled();
        Iterator iterator = GenericUtils.iteratorOf(authenticationIdentitiesProvider == null ? null : authenticationIdentitiesProvider.loadIdentities(clientSession));
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 instanceof String) {
                if (bl3) {
                    this.log.trace("setupDefaultSessionIdentities({}) add password fingerprint={}", (Object)clientSession, (Object)KeyUtils.getFingerPrint(e2.toString()));
                }
                clientSession.addPasswordIdentity((String)e2);
                continue;
            }
            if (e2 instanceof KeyPair) {
                KeyPair keyPair = (KeyPair)e2;
                if (bl3) {
                    this.log.trace("setupDefaultSessionIdentities({}) add identity type={}, fingerprint={}", new Object[]{clientSession, KeyUtils.getKeyType(keyPair), KeyUtils.getFingerPrint(keyPair.getPublic())});
                }
                clientSession.addPublicKeyIdentity(keyPair);
                continue;
            }
            if (!bl2) continue;
            this.log.debug("setupDefaultSessionIdentities({}) ignored identity={}", (Object)clientSession, e2);
        }
    }

    protected IoConnector createConnector() {
        return this.getIoServiceFactory().createConnector(this.getSessionFactory());
    }

    protected SessionFactory createSessionFactory() {
        return new SessionFactory(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + Integer.toHexString(this.hashCode()) + "]";
    }

    public static SimpleClient setUpDefaultSimpleClient() {
        SshClient sshClient = SshClient.setUpDefaultClient();
        sshClient.start();
        return SshClient.wrapAsSimpleClient(sshClient);
    }

    public static SimpleClient wrapAsSimpleClient(SshClient sshClient) {
        Objects.requireNonNull(sshClient, "No client instance");
        SshClient$2 sshClient$2 = new SshClient$2(sshClient);
        return AbstractSimpleClientSessionCreator.wrap(sshClient, sshClient$2);
    }

    public static SshClient setUpDefaultClient() {
        ClientBuilder clientBuilder = ClientBuilder.builder();
        return (SshClient)clientBuilder.build();
    }

    public static SshClient setKeyPairProvider(SshClient sshClient, boolean bl2, boolean bl3, FilePasswordProvider filePasswordProvider, LinkOption ... linkOptionArray) {
        return SshClient.setKeyPairProvider(sshClient, PublicKeyEntry.getDefaultKeysFolderPath(), bl2, bl3, filePasswordProvider, linkOptionArray);
    }

    public static SshClient setKeyPairProvider(SshClient sshClient, Path path, boolean bl2, boolean bl3, FilePasswordProvider filePasswordProvider, LinkOption ... linkOptionArray) {
        KeyPairProvider keyPairProvider = ClientIdentity.loadDefaultKeyPairProvider(path, bl2, bl3, filePasswordProvider, linkOptionArray);
        if (keyPairProvider != null) {
            sshClient.setKeyIdentityProvider(keyPairProvider);
        }
        return sshClient;
    }

    static /* synthetic */ Logger access$000(SshClient sshClient) {
        return sshClient.log;
    }

    static /* synthetic */ Logger access$100(SshClient sshClient) {
        return sshClient.log;
    }

    static /* synthetic */ void access$200(SshClient sshClient, String string, Object object, Object object2, Object object3, Object object4, Object object5, Throwable throwable) {
        sshClient.warn(string, object, object2, object3, object4, object5, throwable);
    }
}

