/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.certificate;

import java.security.KeyPair;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.sshd.common.BaseBuilder;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.OpenSshCertificate$CertificateOption;
import org.apache.sshd.common.config.keys.OpenSshCertificate$Type;
import org.apache.sshd.common.config.keys.OpenSshCertificateImpl;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactory;
import org.apache.sshd.common.util.MapEntryUtils$MapBuilder;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class OpenSshCertificateBuilder {
    protected static final Map SIGNATURE_ALGORITHM_MAP = MapEntryUtils$MapBuilder.builder().put("ssh-rsa", "ssh-rsa-cert-v01@openssh.com").put("ssh-ed25519", "ssh-ed25519-cert-v01@openssh.com").put(KeyPairProvider.ECDSA_SHA2_NISTP256, "ecdsa-sha2-nistp256-cert-v01@openssh.com").put(KeyPairProvider.ECDSA_SHA2_NISTP384, "ecdsa-sha2-nistp384-cert-v01@openssh.com").put(KeyPairProvider.ECDSA_SHA2_NISTP521, "ecdsa-sha2-nistp521-cert-v01@openssh.com").build();
    protected final OpenSshCertificate$Type type;
    protected PublicKey publicKey;
    protected long serial;
    protected String id;
    protected Collection principals;
    protected List criticalOptions;
    protected List extensions;
    protected long validAfter = 0L;
    protected long validBefore = -1L;
    protected byte[] nonce;

    protected OpenSshCertificateBuilder(OpenSshCertificate$Type openSshCertificate$Type) {
        this.type = openSshCertificate$Type;
    }

    public static OpenSshCertificateBuilder userCertificate() {
        return new OpenSshCertificateBuilder(OpenSshCertificate$Type.USER);
    }

    public static OpenSshCertificateBuilder hostCertificate() {
        return new OpenSshCertificateBuilder(OpenSshCertificate$Type.HOST);
    }

    public OpenSshCertificateBuilder publicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public OpenSshCertificateBuilder serial(long l2) {
        this.serial = l2;
        return this;
    }

    public OpenSshCertificateBuilder id(String string) {
        this.id = string;
        return this;
    }

    public OpenSshCertificateBuilder principals(Collection collection) {
        this.principals = collection;
        return this;
    }

    public OpenSshCertificateBuilder criticalOptions(List list) {
        this.validateOptions(list);
        this.criticalOptions = this.lexicallyOrderOptions(list);
        return this;
    }

    public OpenSshCertificateBuilder extensions(List list) {
        this.validateOptions(list);
        this.extensions = this.lexicallyOrderOptions(list);
        return this;
    }

    public OpenSshCertificateBuilder validAfter(long l2) {
        this.validAfter = l2;
        return this;
    }

    public OpenSshCertificateBuilder nonce(byte[] byArray) {
        this.nonce = byArray;
        return this;
    }

    public OpenSshCertificateBuilder validAfter(Instant instant) {
        if (instant == null) {
            return this.validAfter(0L);
        }
        if (Instant.EPOCH.compareTo(instant) <= 0) {
            return this.validAfter(instant.getEpochSecond());
        }
        throw new IllegalArgumentException("Valid-after cannot be < epoch");
    }

    public OpenSshCertificateBuilder validBefore(long l2) {
        this.validBefore = l2;
        return this;
    }

    public OpenSshCertificateBuilder validBefore(Instant instant) {
        if (instant == null) {
            return this.validBefore(-1L);
        }
        if (Instant.EPOCH.compareTo(instant) <= 0) {
            return this.validBefore(instant.getEpochSecond());
        }
        throw new IllegalArgumentException("Valid-before cannot be < epoch");
    }

    protected void validate() {
        if (this.nonce != null && this.nonce.length != 16 && this.nonce.length != 32) {
            throw new IllegalStateException("'nonce' must be 16 or 32 bytes");
        }
        if (this.type == null) {
            throw new IllegalStateException("'type' is required");
        }
        if (this.id == null) {
            throw new IllegalStateException("'id' is required");
        }
        if (this.publicKey == null) {
            throw new IllegalStateException("'publicKey' is required");
        }
    }

    public OpenSshCertificate sign(KeyPair keyPair) {
        return this.sign(keyPair, null);
    }

    public OpenSshCertificate sign(KeyPair keyPair, String string) {
        Object object;
        Object object2;
        this.validate();
        String string2 = KeyUtils.getKeyType(this.publicKey);
        String string3 = (String)SIGNATURE_ALGORITHM_MAP.get(string2);
        if (string3 == null) {
            throw new UnsupportedOperationException("unsupported public key type '" + string2 + "' for OpenSSH Certificate");
        }
        OpenSshCertificateImpl openSshCertificateImpl = new OpenSshCertificateImpl();
        openSshCertificateImpl.setKeyType(string3);
        openSshCertificateImpl.setType(this.type);
        openSshCertificateImpl.setCertPubKey(this.publicKey);
        openSshCertificateImpl.setSerial(this.serial);
        openSshCertificateImpl.setId(this.id);
        if (this.principals != null && !this.principals.isEmpty()) {
            openSshCertificateImpl.setPrincipals(new ArrayList(this.principals));
        }
        if (this.criticalOptions != null && !this.criticalOptions.isEmpty()) {
            openSshCertificateImpl.setCriticalOptions(new ArrayList(this.criticalOptions));
        }
        if (this.extensions != null && !this.extensions.isEmpty()) {
            openSshCertificateImpl.setExtensions(new ArrayList(this.extensions));
        }
        openSshCertificateImpl.setValidAfter(this.validAfter);
        openSshCertificateImpl.setValidBefore(this.validBefore);
        openSshCertificateImpl.setCaPubKey(keyPair.getPublic());
        if (this.nonce != null) {
            openSshCertificateImpl.setNonce(this.nonce);
        } else {
            object2 = new SecureRandom();
            object = new byte[32];
            ((SecureRandom)object2).nextBytes((byte[])object);
            openSshCertificateImpl.setNonce((byte[])object);
        }
        object2 = KeyUtils.getKeyType(keyPair.getPublic());
        if (string != null) {
            ValidateUtils.checkTrue(KeyUtils.getAllEquivalentKeyTypes((String)object2).contains(string), "Invalid CA signature algorithm %s for CA key type %s", string, object2);
            object2 = string;
            object = BuiltinSignatures.fromFactoryName((String)object2);
        } else {
            object = SignatureFactory.resolveSignatureFactory((String)object2, BaseBuilder.DEFAULT_SIGNATURE_PREFERENCE);
        }
        Signature signature = object == null ? null : (Signature)object.create();
        ValidateUtils.checkNotNull((Object)signature, "No signer could be located for signature algorithm=%s", object2);
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
        byteArrayBuffer.putRawPublicKey(openSshCertificateImpl);
        byte[] byArray = byteArrayBuffer.getCompactData();
        signature.initSigner(null, keyPair.getPrivate());
        signature.update(null, byArray);
        ByteArrayBuffer byteArrayBuffer2 = new ByteArrayBuffer();
        byteArrayBuffer2.putString(object.getName());
        byteArrayBuffer2.putBytes(signature.sign(null));
        openSshCertificateImpl.setMessage(byArray);
        openSshCertificateImpl.setSignature(byteArrayBuffer2.getCompactData());
        return openSshCertificateImpl;
    }

    private void validateOptions(List list) {
        if (list != null && !list.isEmpty()) {
            HashSet hashSet = new HashSet();
            Set set = list.stream().filter(openSshCertificate$CertificateOption -> !hashSet.add(openSshCertificate$CertificateOption.getName())).map(OpenSshCertificate$CertificateOption::getName).collect(Collectors.toSet());
            if (!set.isEmpty()) {
                throw new IllegalArgumentException("Duplicate option: " + set);
            }
        }
    }

    private List lexicallyOrderOptions(List list) {
        if (list != null && !list.isEmpty()) {
            return list.stream().sorted(Comparator.comparing(OpenSshCertificate$CertificateOption::getName)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

