/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.unix;

import org.apache.sshd.agent.unix.ChannelAgentForwarding;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelFactory;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.threads.CloseableExecutorService;

public class ChannelAgentForwardingFactory
implements ChannelFactory {
    public static final ChannelAgentForwardingFactory OPENSSH = new ChannelAgentForwardingFactory("auth-agent@openssh.com");
    public static final ChannelAgentForwardingFactory IETF = new ChannelAgentForwardingFactory("auth-agent");
    private final String name;
    private final Factory executorServiceFactory;

    public ChannelAgentForwardingFactory(String string) {
        this(string, null);
    }

    public ChannelAgentForwardingFactory(String string, Factory factory) {
        this.name = ValidateUtils.checkNotNullAndNotEmpty(string, "No channel factory name specified");
        this.executorServiceFactory = factory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Channel createChannel(Session session) {
        CloseableExecutorService closeableExecutorService = this.executorServiceFactory != null ? (CloseableExecutorService)this.executorServiceFactory.create() : null;
        ChannelAgentForwarding channelAgentForwarding = new ChannelAgentForwarding(closeableExecutorService);
        return channelAgentForwarding;
    }
}

