/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.unix;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.sshd.agent.unix.AprLibrary;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.channel.AbstractServerChannel;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.Local;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.Socket;

public class ChannelAgentForwarding
extends AbstractServerChannel {
    private String authSocket;
    private long pool;
    private long handle;
    private OutputStream out;
    private CloseableExecutorService forwardService;
    private Future forwarder;

    public ChannelAgentForwarding(CloseableExecutorService closeableExecutorService) {
        super("", Collections.emptyList(), closeableExecutorService);
    }

    @Override
    protected OpenFuture doInit(Buffer buffer) {
        DefaultOpenFuture defaultOpenFuture = new DefaultOpenFuture(this, this);
        try {
            CloseableExecutorService closeableExecutorService;
            this.out = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
            this.authSocket = this.getString("SSH_AUTH_SOCK");
            this.pool = Pool.create((long)AprLibrary.getInstance().getRootPool());
            this.handle = Local.create((String)this.authSocket, (long)this.pool);
            int n2 = Local.connect((long)this.handle, (long)0L);
            if (n2 != 0) {
                ChannelAgentForwarding.throwException(n2);
            }
            this.forwardService = (closeableExecutorService = this.getExecutorService()) == null ? ThreadUtils.newSingleThreadExecutor("ChannelAgentForwarding[" + this.authSocket + "]") : ThreadUtils.noClose(closeableExecutorService);
            int n3 = (Integer)CoreModuleProperties.FORWARDER_BUFFER_SIZE.getRequired(this);
            ValidateUtils.checkTrue(n3 >= 127, "Copy buf size below min.: %d", n3);
            ValidateUtils.checkTrue(n3 <= Short.MAX_VALUE, "Copy buf size above max.: %d", n3);
            this.forwarder = this.forwardService.submit(() -> {
                try {
                    byte[] byArray = new byte[n3];
                    while (true) {
                        int n3;
                        if ((n3 = Socket.recv((long)this.handle, (byte[])byArray, (int)0, (int)byArray.length)) <= 0) {
                            continue;
                        }
                        this.out.write(byArray, 0, n3);
                        this.out.flush();
                    }
                }
                catch (IOException iOException) {
                    this.close(true);
                    return;
                }
            });
            this.signalChannelOpenSuccess();
            defaultOpenFuture.setOpened();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.peelException(throwable);
            this.signalChannelOpenFailure(throwable2);
            defaultOpenFuture.setException(throwable2);
        }
        return defaultOpenFuture;
    }

    private void closeImmediately0() {
        super.close(true);
        Socket.close((long)this.handle);
        try {
            if (this.forwarder != null && !this.forwarder.isDone()) {
                this.forwarder.cancel(true);
            }
        }
        finally {
            this.forwarder = null;
        }
        try {
            if (this.forwardService != null) {
                List<Runnable> list = this.forwardService.shutdownNow();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Shut down runners count={}", (Object)GenericUtils.size(list));
                }
            }
        }
        finally {
            this.forwardService = null;
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(super.getInnerCloseable()).run(this.toString(), this::closeImmediately0).build();
    }

    @Override
    protected void doWriteData(byte[] byArray, int n2, long l2) {
        ValidateUtils.checkTrue(l2 <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", l2);
        int n3 = Socket.send((long)this.handle, (byte[])byArray, (int)n2, (int)((int)l2));
        if (n3 < 0) {
            ChannelAgentForwarding.throwException(n3);
        }
    }

    @Override
    protected void doWriteExtendedData(byte[] byArray, int n2, long l2) {
        throw new UnsupportedOperationException("AgentForward channel does not support extended data");
    }

    private static void throwException(int n2) {
        throw new IOException(Error.strerror((int)(-n2)) + " (code: " + n2 + ")");
    }
}

