/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.unix;

import java.io.File;
import java.io.IOException;
import org.apache.sshd.common.util.OsUtils;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.Pool;

public final class AprLibrary {
    private static AprLibrary library;
    private final long pool;

    private AprLibrary() {
        try {
            Library.initialize(null);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Error loading Apache Portable Runtime (APR).", throwable);
        }
        this.pool = Pool.create((long)0L);
    }

    public static synchronized AprLibrary getInstance() {
        if (!AprLibrary.isInitialized()) {
            AprLibrary.initialize();
        }
        return library;
    }

    private static synchronized void initialize() {
        if (library == null) {
            library = new AprLibrary();
        }
    }

    public static synchronized boolean isInitialized() {
        return library != null;
    }

    protected void finalize() {
        library = null;
        Pool.destroy((long)this.pool);
        Library.terminate();
        super.finalize();
    }

    long getRootPool() {
        return this.pool;
    }

    static String createLocalSocketAddress() {
        String string;
        AprLibrary.initialize();
        if (OsUtils.isUNIX()) {
            File file = File.createTempFile("mina", "apr");
            if (!file.delete() || !file.mkdir()) {
                throw new IOException("Cannot create secure temp directory");
            }
            AprLibrary.chmodOwner(file.getAbsolutePath(), true);
            File file2 = File.createTempFile("mina", "apr", file);
            file2.delete();
            string = file2.getAbsolutePath();
        } else {
            File file = File.createTempFile("mina", "apr");
            file.delete();
            string = "\\\\.\\pipe\\" + file.getName();
        }
        return string;
    }

    static void secureLocalSocket(String string, long l2) {
        if (OsUtils.isUNIX()) {
            AprLibrary.chmodOwner(string, false);
        }
    }

    private static void chmodOwner(String string, boolean bl2) {
        int n2 = 1536;
        if (bl2) {
            n2 |= 0x100;
        }
        if (org.apache.tomcat.jni.File.permsSet((String)string, (int)n2) != 0) {
            throw new IOException("Unable to secure local socket");
        }
    }
}

