/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.unix;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.SshAgentServer;
import org.apache.sshd.agent.unix.AgentForwardedChannel;
import org.apache.sshd.agent.unix.AprLibrary;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.Local;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.Socket;

public class AgentServerProxy
extends AbstractLoggingBean
implements SshAgentServer {
    private static final byte[] END_OF_STREAM_MESSAGE = new byte[]{"END_OF_STREAM".getBytes(StandardCharsets.UTF_8)[0]};
    private final ConnectionService service;
    private final String authSocket;
    private final long pool;
    private final long handle;
    private Future piper;
    private final CloseableExecutorService pipeService;
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final AtomicBoolean innerFinished = new AtomicBoolean(false);

    public AgentServerProxy(ConnectionService connectionService) {
        this(connectionService, null);
    }

    public AgentServerProxy(ConnectionService connectionService, CloseableExecutorService closeableExecutorService) {
        this.service = connectionService;
        try {
            String string = AprLibrary.createLocalSocketAddress();
            this.pool = Pool.create((long)AprLibrary.getInstance().getRootPool());
            this.handle = Local.create((String)string, (long)this.pool);
            this.authSocket = string;
            int n2 = Local.bind((long)this.handle, (long)0L);
            if (n2 != 0) {
                throw AgentServerProxy.toIOException(n2);
            }
            AprLibrary.secureLocalSocket(string, this.handle);
            n2 = Local.listen((long)this.handle, (int)0);
            if (n2 != 0) {
                throw AgentServerProxy.toIOException(n2);
            }
            this.pipeService = closeableExecutorService == null ? ThreadUtils.newSingleThreadExecutor("AgentServerProxy-PIPE-" + string) : ThreadUtils.noClose(closeableExecutorService);
            this.piper = this.pipeService.submit(() -> {
                try {
                    while (this.isOpen()) {
                        try {
                            long l2 = Local.accept((long)this.handle);
                            if (!this.isOpen()) {
                                break;
                            }
                            Session session = this.service.getSession();
                            Socket.timeoutSet((long)l2, (long)(((Duration)CoreModuleProperties.AUTH_SOCKET_TIMEOUT.getRequired(session)).toMillis() * 1000L));
                            String string = (String)CoreModuleProperties.PROXY_CHANNEL_TYPE.getRequired(session);
                            AgentForwardedChannel agentForwardedChannel = new AgentForwardedChannel(l2, string);
                            this.service.registerChannel(agentForwardedChannel);
                            agentForwardedChannel.open().verify((Duration)CoreModuleProperties.CHANNEL_OPEN_TIMEOUT.getRequired(session));
                        }
                        catch (Exception exception) {
                            this.debug("run(open={}) {} while authentication forwarding: {}", this.isOpen(), exception.getClass().getSimpleName(), exception.getMessage(), exception);
                        }
                    }
                }
                finally {
                    this.innerFinished.set(true);
                }
            });
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new SshException(exception);
        }
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    public CloseableExecutorService getExecutorService() {
        return this.pipeService;
    }

    @Override
    public String getId() {
        return this.authSocket;
    }

    @Override
    public synchronized void close() {
        boolean bl2;
        block16: {
            if (!this.open.getAndSet(false)) {
                return;
            }
            bl2 = this.log.isDebugEnabled();
            if (this.handle != 0L) {
                int n2;
                block15: {
                    if (!this.innerFinished.get()) {
                        try {
                            this.signalEOS(AprLibrary.getInstance(), bl2);
                        }
                        catch (Exception exception) {
                            if (!bl2) break block15;
                            this.log.debug("Exception signalling EOS to the PIPE socket: " + this.authSocket, (Throwable)exception);
                        }
                    }
                }
                if ((n2 = Socket.close((long)this.handle)) != 0) {
                    this.log.warn("Exceptions closing the PIPE: {}. APR error code: {} ", (Object)this.authSocket, (Object)n2);
                }
            }
            try {
                if (this.authSocket != null) {
                    this.removeSocketFile(this.authSocket, bl2);
                }
            }
            catch (Exception exception) {
                if (!bl2) break block16;
                this.log.debug("Exception deleting the PIPE socket: " + this.authSocket, (Throwable)exception);
            }
        }
        try {
            if (this.piper != null && !this.piper.isDone()) {
                this.piper.cancel(true);
            }
        }
        finally {
            this.piper = null;
        }
        CloseableExecutorService closeableExecutorService = this.getExecutorService();
        if (closeableExecutorService != null && !closeableExecutorService.isShutdown()) {
            List<Runnable> list = closeableExecutorService.shutdownNow();
            if (bl2) {
                this.log.debug("Shut down runners count={}", (Object)GenericUtils.size(list));
            }
        }
    }

    protected File removeSocketFile(String string, boolean bl2) {
        File file = new File(string);
        if (file.exists()) {
            this.deleteFile(file, "Deleted PIPE socket {}", bl2);
            if (OsUtils.isUNIX()) {
                this.deleteFile(file.getParentFile(), "Deleted parent PIPE socket {}", bl2);
            }
        }
        return file;
    }

    protected void signalEOS(AprLibrary aprLibrary, boolean bl2) {
        int n2;
        long l2 = Pool.create((long)aprLibrary.getRootPool());
        long l3 = Local.create((String)this.authSocket, (long)l2);
        long l4 = Local.connect((long)l3, (long)0L);
        if (l4 != 0L && bl2) {
            this.log.debug("Unable to connect to socket PIPE {}. APR errcode {}", (Object)this.authSocket, (Object)l4);
        }
        if ((n2 = Socket.send((long)l3, (byte[])END_OF_STREAM_MESSAGE, (int)0, (int)1)) != 1 && bl2) {
            this.log.debug("Unable to send signal the EOS for {}. APR retcode {} != 1", (Object)this.authSocket, (Object)n2);
        }
    }

    protected boolean deleteFile(File file, String string, boolean bl2) {
        boolean bl3 = file.delete();
        if (bl3 && bl2) {
            this.log.debug(string, (Object)file);
        }
        return bl3;
    }

    public static IOException toIOException(int n2) {
        return new IOException(Error.strerror((int)(-n2)) + " (code: " + n2 + ")");
    }
}

