/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.unix;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.local.AgentImpl;
import org.apache.sshd.agent.unix.AgentServer$SshAgentSession;
import org.apache.sshd.agent.unix.AprLibrary;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ExecutorServiceCarrier;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.Local;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.Socket;

public class AgentServer
extends AbstractLoggingBean
implements Closeable,
ExecutorServiceCarrier {
    private final SshAgent agent;
    private final CloseableExecutorService service;
    private Future agentThread;
    private String authSocket;
    private long pool;
    private long handle;

    public AgentServer() {
        this((CloseableExecutorService)null);
    }

    public AgentServer(CloseableExecutorService closeableExecutorService) {
        this(new AgentImpl(), closeableExecutorService);
    }

    public AgentServer(SshAgent sshAgent, CloseableExecutorService closeableExecutorService) {
        this.agent = sshAgent;
        this.service = closeableExecutorService == null ? ThreadUtils.newSingleThreadExecutor("AgentServer[" + sshAgent + "]") : closeableExecutorService;
    }

    public SshAgent getAgent() {
        return this.agent;
    }

    @Override
    public CloseableExecutorService getExecutorService() {
        return this.service;
    }

    public String start() {
        this.authSocket = AprLibrary.createLocalSocketAddress();
        this.pool = Pool.create((long)AprLibrary.getInstance().getRootPool());
        this.handle = Local.create((String)this.authSocket, (long)this.pool);
        int n2 = Local.bind((long)this.handle, (long)0L);
        if (n2 != 0) {
            AgentServer.throwException(n2);
        }
        AprLibrary.secureLocalSocket(this.authSocket, this.handle);
        n2 = Local.listen((long)this.handle, (int)0);
        if (n2 != 0) {
            AgentServer.throwException(n2);
        }
        CloseableExecutorService closeableExecutorService = this.getExecutorService();
        this.agentThread = closeableExecutorService.submit(() -> {
            try {
                while (true) {
                    long l2 = Local.accept((long)this.handle);
                    Socket.timeoutSet((long)l2, (long)10000000L);
                    new AgentServer$SshAgentSession(l2, this.agent).run();
                }
            }
            catch (Exception exception) {
                this.log.error("Failed to run session", (Throwable)exception);
                return;
            }
        });
        return this.authSocket;
    }

    @Override
    public void close() {
        IOException iOException = null;
        try {
            this.agent.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        Socket.close((long)this.handle);
        try {
            if (this.agentThread != null && !this.agentThread.isDone()) {
                this.agentThread.cancel(true);
            }
        }
        finally {
            this.agentThread = null;
        }
        CloseableExecutorService closeableExecutorService = this.getExecutorService();
        if (closeableExecutorService != null && !closeableExecutorService.isShutdown()) {
            List<Runnable> list = closeableExecutorService.shutdownNow();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Shut down runners count={}", (Object)GenericUtils.size(list));
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    private static void throwException(int n2) {
        throw new IOException(Error.strerror((int)(-n2)) + " (code: " + n2 + ")");
    }

    static /* synthetic */ void access$000(int n2) {
        AgentServer.throwException(n2);
    }
}

