/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.unix;

import java.io.OutputStream;
import org.apache.sshd.agent.unix.AgentServerProxy;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.channel.StreamingChannel$Streaming;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.tomcat.jni.Socket;

public class AgentForwardedChannel
extends AbstractClientChannel
implements Runnable {
    private final long socket;

    public AgentForwardedChannel(long l2, String string) {
        super(string);
        this.socket = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int n2;
            byte[] byArray = new byte[1024];
            OutputStream outputStream = this.getInvertedIn();
            while ((n2 = Socket.recv((long)this.socket, (byte[])byArray, (int)0, (int)byArray.length)) != -70014) {
                if (n2 < 0) {
                    throw AgentServerProxy.toIOException(n2);
                }
                outputStream.write(byArray, 0, n2);
                outputStream.flush();
            }
        }
        catch (Exception exception) {
            this.log.warn("Processing loop exception", (Throwable)exception);
        }
        finally {
            this.close(false);
        }
    }

    @Override
    protected synchronized void doOpen() {
        ValidateUtils.checkTrue(!StreamingChannel$Streaming.Async.equals((Object)this.streaming), "Asynchronous streaming isn't supported yet on this channel");
        this.invertedIn = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(super.getInnerCloseable()).run(this.toString(), () -> Socket.close((long)this.socket)).build();
    }

    @Override
    protected synchronized void doWriteData(byte[] byArray, int n2, long l2) {
        ValidateUtils.checkTrue(l2 <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", l2);
        LocalWindow localWindow = this.getLocalWindow();
        localWindow.release(l2);
        int n3 = Socket.send((long)this.socket, (byte[])byArray, (int)n2, (int)((int)l2));
        if (n3 < 0) {
            throw AgentServerProxy.toIOException(n3);
        }
    }
}

