/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StreamCorruptedException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.common.AbstractAgentProxy;
import org.apache.sshd.agent.unix.AprLibrary;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.FactoryManagerHolder;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.Local;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.Socket;

public class AgentClient
extends AbstractAgentProxy
implements Runnable,
FactoryManagerHolder {
    public static final String MESSAGE_POLL_FREQUENCY = "agent-client-message-poll-time";
    public static final long DEFAULT_MESSAGE_POLL_FREQUENCY = TimeUnit.MINUTES.toMillis(2L);
    private final String authSocket;
    private final FactoryManager manager;
    private final long pool;
    private final long handle;
    private final Buffer receiveBuffer;
    private final Queue messages;
    private Future pumper;
    private final AtomicBoolean open = new AtomicBoolean(true);

    public AgentClient(FactoryManager factoryManager, String string) {
        this(factoryManager, string, null);
    }

    public AgentClient(FactoryManager factoryManager, String string, CloseableExecutorService closeableExecutorService) {
        super(closeableExecutorService == null ? ThreadUtils.newSingleThreadExecutor("AgentClient[" + string + "]") : closeableExecutorService);
        this.manager = Objects.requireNonNull(factoryManager, "No factory manager instance provided");
        this.authSocket = string;
        try {
            AprLibrary aprLibrary = AprLibrary.getInstance();
            this.pool = Pool.create((long)aprLibrary.getRootPool());
            this.handle = Local.create((String)string, (long)this.pool);
            int n2 = Local.connect((long)this.handle, (long)0L);
            if (n2 != 0) {
                this.throwException(n2);
            }
            this.receiveBuffer = new ByteArrayBuffer();
            this.messages = new ArrayBlockingQueue(10);
            CloseableExecutorService closeableExecutorService2 = this.getExecutorService();
            this.pumper = closeableExecutorService2.submit(this);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new SshException(exception);
        }
    }

    @Override
    public FactoryManager getFactoryManager() {
        return this.manager;
    }

    public String getAuthSocket() {
        return this.authSocket;
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        block16: {
            byte[] byArray = new byte[1024];
            while (this.isOpen()) {
                int n2 = Socket.recv((long)this.handle, (byte[])byArray, (int)0, (int)byArray.length);
                if (n2 < 0) {
                    this.throwException(n2);
                }
                this.messageReceived(new ByteArrayBuffer(byArray, 0, n2));
            }
            try {
                this.close();
            }
            catch (IOException iOException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("run({}) {} while closing: {}", new Object[]{this, iOException.getClass().getSimpleName(), iOException.getMessage()});
                }
                break block16;
            }
            catch (Exception exception) {
                block17: {
                    try {
                        boolean bl2 = this.log.isDebugEnabled();
                        if (this.isOpen()) {
                            this.log.warn("run({}) {} while still open: {}", new Object[]{this, exception.getClass().getSimpleName(), exception.getMessage()});
                            if (bl2) {
                                this.log.debug("run(" + this + ") open client exception", (Throwable)exception);
                            }
                            break block17;
                        }
                        if (!bl2) break block17;
                        this.log.debug("run(" + this + ") closed client loop exception", (Throwable)exception);
                    }
                    catch (Throwable throwable) {
                        block18: {
                            try {
                                this.close();
                            }
                            catch (IOException iOException) {
                                if (!this.log.isDebugEnabled()) break block18;
                                this.log.debug("run({}) {} while closing: {}", new Object[]{this, iOException.getClass().getSimpleName(), iOException.getMessage()});
                            }
                        }
                        throw throwable;
                    }
                }
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("run({}) {} while closing: {}", new Object[]{this, iOException.getClass().getSimpleName(), iOException.getMessage()});
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void messageReceived(Buffer buffer) {
        ByteArrayBuffer byteArrayBuffer = null;
        Object object = this.receiveBuffer;
        synchronized (object) {
            this.receiveBuffer.putBuffer(buffer);
            if (this.receiveBuffer.available() >= 4) {
                int n2 = this.receiveBuffer.rpos();
                int n3 = this.receiveBuffer.getInt();
                if (n3 < 0) {
                    throw new StreamCorruptedException("Illogical message length: " + n3);
                }
                this.receiveBuffer.rpos(n2);
                if (this.receiveBuffer.available() >= 4 + n3) {
                    byteArrayBuffer = new ByteArrayBuffer(this.receiveBuffer.getBytes());
                    this.receiveBuffer.compact();
                }
            }
        }
        if (byteArrayBuffer != null) {
            object = this.messages;
            synchronized (object) {
                this.messages.offer(byteArrayBuffer);
                this.messages.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.open.getAndSet(false)) {
            Socket.close((long)this.handle);
        }
        Queue queue = this.messages;
        synchronized (queue) {
            this.messages.notifyAll();
        }
        if (this.pumper != null && !this.pumper.isDone()) {
            this.pumper.cancel(true);
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized Buffer request(Buffer buffer) {
        int n2 = buffer.wpos();
        buffer.wpos(0);
        buffer.putUInt(n2 - 4);
        buffer.wpos(n2);
        Queue queue = this.messages;
        synchronized (queue) {
            int n3 = Socket.send((long)this.handle, (byte[])buffer.array(), (int)buffer.rpos(), (int)buffer.available());
            if (n3 < 0) {
                this.throwException(n3);
            }
            return this.waitForMessageBuffer();
        }
    }

    protected Buffer waitForMessageBuffer() {
        FactoryManager factoryManager = this.getFactoryManager();
        long l2 = PropertyResolverUtils.getLongProperty(factoryManager, MESSAGE_POLL_FREQUENCY, DEFAULT_MESSAGE_POLL_FREQUENCY);
        if (l2 <= 0L) {
            l2 = DEFAULT_MESSAGE_POLL_FREQUENCY;
        }
        boolean bl2 = this.log.isTraceEnabled();
        int n2 = 1;
        while (true) {
            if (!this.isOpen()) {
                throw new SshException("Client is being closed");
            }
            if (!this.messages.isEmpty()) {
                return (Buffer)this.messages.poll();
            }
            if (bl2) {
                this.log.trace("waitForMessageBuffer({}) wait iteration #{}", (Object)this, (Object)n2);
            }
            try {
                this.messages.wait(l2);
            }
            catch (InterruptedException interruptedException) {
                throw (IOException)new InterruptedIOException("Interrupted while waiting for messages at iteration #" + n2).initCause(interruptedException);
            }
            ++n2;
        }
    }

    protected void throwException(int n2) {
        throw new IOException(Error.strerror((int)(-n2)) + " (code: " + n2 + ")");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[socket=" + this.getAuthSocket() + "]";
    }
}

