/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.local;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.SshAgentServer;
import org.apache.sshd.agent.local.AgentServerProxy;
import org.apache.sshd.agent.local.LocalAgentFactory;
import org.apache.sshd.agent.local.ProxyAgentFactory$1;
import org.apache.sshd.agent.unix.AprLibrary;
import org.apache.sshd.agent.unix.UnixAgentFactory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.session.ServerSession;

public class ProxyAgentFactory
implements SshAgentFactory {
    private final Map proxies = new ConcurrentHashMap();

    @Override
    public List getChannelForwardingFactories(FactoryManager factoryManager) {
        return ProxyAgentFactory.isPreferredUnixAgent(factoryManager) ? UnixAgentFactory.DEFAULT_FORWARDING_CHANNELS : LocalAgentFactory.DEFAULT_FORWARDING_CHANNELS;
    }

    @Override
    public SshAgent createClient(Session session, FactoryManager factoryManager) {
        String string = factoryManager.getString("SSH_AUTH_SOCK");
        if (GenericUtils.isEmpty(string)) {
            throw new IllegalStateException("No SSH_AUTH_SOCK environment variable set");
        }
        AgentServerProxy agentServerProxy = (AgentServerProxy)this.proxies.get(string);
        if (agentServerProxy == null) {
            throw new IllegalStateException("No ssh agent found for ID=" + string);
        }
        return agentServerProxy.createClient();
    }

    @Override
    public SshAgentServer createServer(ConnectionService connectionService) {
        Session session = connectionService.getSession();
        ValidateUtils.checkInstanceOf((Object)session, ServerSession.class, "The session used to create an agent server proxy must be a server session: %s", (Object)session);
        AgentServerProxy agentServerProxy = new AgentServerProxy(connectionService);
        this.proxies.put(agentServerProxy.getId(), agentServerProxy);
        return new ProxyAgentFactory$1(this, agentServerProxy);
    }

    public static boolean isPreferredUnixAgent(PropertyResolver propertyResolver) {
        if (((Boolean)CoreModuleProperties.PREFER_UNIX_AGENT.getRequired(propertyResolver)).booleanValue()) {
            try {
                if (AprLibrary.getInstance() != null) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    static /* synthetic */ Map access$000(ProxyAgentFactory proxyAgentFactory) {
        return proxyAgentFactory.proxies;
    }
}

