/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.local;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Objects;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.local.ChannelAgentForwarding$AgentClient;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.server.channel.AbstractServerChannel;

public class ChannelAgentForwarding
extends AbstractServerChannel {
    private OutputStream out;
    private SshAgent agent;
    private ChannelAgentForwarding$AgentClient client;

    public ChannelAgentForwarding(CloseableExecutorService closeableExecutorService) {
        super("", Collections.emptyList(), closeableExecutorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OpenFuture doInit(Buffer buffer) {
        DefaultOpenFuture defaultOpenFuture = new DefaultOpenFuture(this, this);
        String string = "auth-agent";
        try {
            this.out = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
            Session session = this.getSession();
            FactoryManager factoryManager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
            SshAgentFactory sshAgentFactory = Objects.requireNonNull(factoryManager.getAgentFactory(), "No agent factory");
            this.agent = sshAgentFactory.createClient(session, factoryManager);
            this.client = new ChannelAgentForwarding$AgentClient(this);
            this.signalChannelOpenSuccess();
            defaultOpenFuture.setOpened();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.peelException(throwable);
            string = throwable2.getClass().getSimpleName();
            this.signalChannelOpenFailure(throwable2);
            defaultOpenFuture.setException(throwable2);
        }
        finally {
            this.notifyStateChanged(string);
        }
        return defaultOpenFuture;
    }

    @Override
    public void handleEof() {
        try {
            if (this.agent != null && this.agent.isOpen()) {
                this.agent.close();
            }
        }
        finally {
            super.handleEof();
        }
    }

    private void closeImmediately0() {
        try {
            if (this.agent != null && this.agent.isOpen()) {
                try {
                    this.agent.close();
                }
                catch (IOException iOException) {
                    this.log.error("closeImmediately0({}) Failed ({}) to close open local agent: {}", new Object[]{this, iOException.getClass().getSimpleName(), iOException.getMessage()});
                }
            }
        }
        finally {
            super.close(true);
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(super.getInnerCloseable()).run(this.toString(), this::closeImmediately0).build();
    }

    @Override
    protected void doWriteData(byte[] byArray, int n2, long l2) {
        ValidateUtils.checkTrue(l2 <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", l2);
        this.client.messageReceived(new ByteArrayBuffer(byArray, n2, (int)l2));
    }

    @Override
    protected void doWriteExtendedData(byte[] byArray, int n2, long l2) {
        throw new UnsupportedOperationException("AgentForward channel does not support extended data");
    }

    static /* synthetic */ SshAgent access$000(ChannelAgentForwarding channelAgentForwarding) {
        return channelAgentForwarding.agent;
    }

    static /* synthetic */ OutputStream access$100(ChannelAgentForwarding channelAgentForwarding) {
        return channelAgentForwarding.out;
    }
}

