/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.local;

import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentServer;
import org.apache.sshd.agent.local.AgentForwardedChannel;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.core.CoreModuleProperties;

public class AgentServerProxy
extends AbstractLoggingBean
implements SshAgentServer {
    private final ConnectionService service;
    private final String id;
    private final AtomicBoolean open = new AtomicBoolean(true);

    public AgentServerProxy(ConnectionService connectionService) {
        this.service = Objects.requireNonNull(connectionService, "No connection service provided");
        this.id = UUID.randomUUID().toString();
    }

    public SshAgent createClient() {
        try {
            Session session = this.service.getSession();
            String string = (String)CoreModuleProperties.PROXY_CHANNEL_TYPE.getRequired(session);
            AgentForwardedChannel agentForwardedChannel = new AgentForwardedChannel(string);
            this.service.registerChannel(agentForwardedChannel);
            agentForwardedChannel.open().verify((Duration)CoreModuleProperties.CHANNEL_OPEN_TIMEOUT.getRequired(agentForwardedChannel));
            return agentForwardedChannel.getAgent();
        }
        catch (Throwable throwable) {
            if (this.log.isDebugEnabled()) {
                this.log.warn("createClient({})[{}] failed to create client: {}", new Object[]{this.service.getSession(), this.getId(), throwable.toString()});
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException("Failed (" + throwable.getClass().getSimpleName() + ") to create client: " + throwable.getMessage(), throwable);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void close() {
        if (this.open.getAndSet(false) && this.log.isDebugEnabled()) {
            this.log.debug("closed({})[{}]", (Object)this.service.getSession(), (Object)this.getId());
        }
    }
}

