/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.local;

import java.io.IOException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentKeyConstraint;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentImpl
implements SshAgent {
    private static final Logger LOG = LoggerFactory.getLogger(AgentImpl.class);
    private final List keys = new ArrayList();
    private final AtomicBoolean open = new AtomicBoolean(true);

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public Iterable getIdentities() {
        if (!this.isOpen()) {
            throw new SshException("Agent closed");
        }
        return GenericUtils.map(this.keys, entry -> new AbstractMap.SimpleImmutableEntry<PublicKey, String>(((KeyPair)entry.getKey()).getPublic(), (String)entry.getValue()));
    }

    @Override
    public Map.Entry sign(SessionContext sessionContext, PublicKey publicKey, String string, byte[] byArray) {
        if (!this.isOpen()) {
            throw new SshException("Agent closed");
        }
        try {
            Signature signature;
            Map.Entry entry = Objects.requireNonNull(AgentImpl.getKeyPair(this.keys, publicKey), "Key not found");
            String string2 = (String)entry.getValue();
            KeyPair keyPair = (KeyPair)ValidateUtils.checkNotNull((Object)((KeyPair)entry.getKey()), "No key pair for agent=%s", (Object)string2);
            PublicKey publicKey2 = (PublicKey)ValidateUtils.checkNotNull((Object)keyPair.getPublic(), "No public key for agent=%s", (Object)string2);
            NamedFactory namedFactory = SignatureFactory.resolveSignatureFactoryByPublicKey(publicKey2, string);
            Signature signature2 = signature = namedFactory == null ? null : (Signature)namedFactory.create();
            if (signature == null) {
                throw new InvalidKeySpecException("No signer found for " + publicKey2.getClass().getSimpleName() + " when algorithm=" + string + " requested for " + KeyUtils.getKeyType(publicKey2));
            }
            signature.initSigner(sessionContext, keyPair.getPrivate());
            signature.update(sessionContext, byArray);
            byte[] byArray2 = signature.sign(sessionContext);
            return new AbstractMap.SimpleImmutableEntry<String, byte[]>(namedFactory.getName(), byArray2);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new SshException(exception);
        }
    }

    @Override
    public void addIdentity(KeyPair keyPair, String string, SshAgentKeyConstraint ... sshAgentKeyConstraintArray) {
        if (!this.isOpen()) {
            throw new SshException("Agent closed");
        }
        if (!GenericUtils.isEmpty(sshAgentKeyConstraintArray) && LOG.isDebugEnabled()) {
            LOG.debug("addIdentity({})[{}] {}: local agent does not implement key constraints; ignoring", new Object[]{KeyUtils.getKeyType(keyPair), string, KeyUtils.getFingerPrint(keyPair.getPublic())});
        }
        this.keys.add(new AbstractMap.SimpleImmutableEntry<KeyPair, String>(Objects.requireNonNull(keyPair, "No key"), string));
    }

    @Override
    public KeyPair resolveLocalIdentity(PublicKey publicKey) {
        Map.Entry entry = AgentImpl.getKeyPair(this.keys, publicKey);
        return entry == null ? null : (KeyPair)entry.getKey();
    }

    @Override
    public void removeIdentity(PublicKey publicKey) {
        if (!this.isOpen()) {
            throw new SshException("Agent closed");
        }
        Map.Entry entry = AgentImpl.getKeyPair(this.keys, publicKey);
        if (entry == null) {
            throw new SshException("Key not found");
        }
        this.keys.remove(entry);
    }

    @Override
    public void removeAllIdentities() {
        if (!this.isOpen()) {
            throw new SshException("Agent closed");
        }
        this.keys.clear();
    }

    @Override
    public void close() {
        if (this.open.getAndSet(false)) {
            this.keys.clear();
        }
    }

    protected static Map.Entry getKeyPair(Collection collection, PublicKey publicKey) {
        if (GenericUtils.isEmpty(collection) || publicKey == null) {
            return null;
        }
        for (Map.Entry entry : collection) {
            KeyPair keyPair = (KeyPair)entry.getKey();
            if (!KeyUtils.compareKeys(publicKey, keyPair.getPublic())) continue;
            return entry;
        }
        return null;
    }
}

