/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.local;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.local.AgentForwardedChannel$1;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.channel.StreamingChannel$Streaming;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class AgentForwardedChannel
extends AbstractClientChannel {
    public static final String MESSAGE_POLL_FREQUENCY = "agent-fwd-channel-message-poll-time";
    public static final long DEFAULT_MESSAGE_POLL_FREQUENCY = TimeUnit.MINUTES.toMillis(2L);
    private final Queue messages = new ArrayBlockingQueue(10);
    private final Buffer receiveBuffer = new ByteArrayBuffer();

    public AgentForwardedChannel(String string) {
        super(string);
        this.addCloseFutureListener(closeFuture -> {
            Queue queue = this.messages;
            synchronized (queue) {
                this.messages.notifyAll();
            }
        });
    }

    public SshAgent getAgent() {
        AgentForwardedChannel$1 agentForwardedChannel$1 = new AgentForwardedChannel$1(this, null);
        String string = PropertyResolverUtils.getString(this.getSession(), "agent-fw-auth-type");
        agentForwardedChannel$1.setChannelType(string);
        return agentForwardedChannel$1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Buffer request(Buffer buffer) {
        int n2 = buffer.available();
        Queue queue = this.messages;
        synchronized (queue) {
            OutputStream outputStream = this.getInvertedIn();
            outputStream.write(buffer.array(), buffer.rpos(), n2);
            outputStream.flush();
            LocalWindow localWindow = this.getLocalWindow();
            localWindow.release(n2);
            return this.waitForMessageBuffer();
        }
    }

    protected Buffer waitForMessageBuffer() {
        Session session = this.getSession();
        long l2 = PropertyResolverUtils.getLongProperty(session, MESSAGE_POLL_FREQUENCY, DEFAULT_MESSAGE_POLL_FREQUENCY);
        if (l2 <= 0L) {
            l2 = DEFAULT_MESSAGE_POLL_FREQUENCY;
        }
        boolean bl2 = this.log.isTraceEnabled();
        int n2 = 1;
        while (true) {
            if (this.isClosing() || !this.isOpen()) {
                throw new SshException("Channel is being closed");
            }
            if (!this.messages.isEmpty()) {
                return (Buffer)this.messages.poll();
            }
            if (bl2) {
                this.log.trace("waitForMessageBuffer({}) wait iteration #{}", (Object)this, (Object)n2);
            }
            try {
                this.messages.wait(l2);
            }
            catch (InterruptedException interruptedException) {
                throw (IOException)new InterruptedIOException("Interrupted while waiting for messages at iteration #" + n2).initCause(interruptedException);
            }
            ++n2;
        }
    }

    @Override
    protected void doOpen() {
        ValidateUtils.checkTrue(!StreamingChannel$Streaming.Async.equals((Object)this.streaming), "Asynchronous streaming isn't supported yet on this channel");
        this.invertedIn = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWriteData(byte[] byArray, int n2, long l2) {
        ValidateUtils.checkTrue(l2 <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", l2);
        ByteArrayBuffer byteArrayBuffer = null;
        Object object = this.receiveBuffer;
        synchronized (object) {
            this.receiveBuffer.putBuffer(new ByteArrayBuffer(byArray, n2, (int)l2));
            if (this.receiveBuffer.available() >= 4) {
                n2 = this.receiveBuffer.rpos();
                l2 = this.receiveBuffer.getInt();
                this.receiveBuffer.rpos(n2);
                if ((long)this.receiveBuffer.available() >= 4L + l2) {
                    byteArrayBuffer = new ByteArrayBuffer(this.receiveBuffer.getBytes());
                    this.receiveBuffer.compact();
                }
            }
        }
        if (byteArrayBuffer != null) {
            object = this.messages;
            synchronized (object) {
                this.messages.offer(byteArrayBuffer);
                this.messages.notifyAll();
            }
        }
    }
}

