/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.common;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.SshAgentServer;
import org.apache.sshd.agent.common.AgentForwardSupport;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.closeable.AbstractCloseable;

public class DefaultAgentForwardSupport
extends AbstractCloseable
implements AgentForwardSupport {
    private final ConnectionService serviceInstance;
    private final AtomicReference agentServerHolder = new AtomicReference();

    public DefaultAgentForwardSupport(ConnectionService connectionService) {
        this.serviceInstance = Objects.requireNonNull(connectionService, "No connection service");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String initialize() {
        Session session = this.serviceInstance.getSession();
        try {
            SshAgentServer sshAgentServer;
            Object object = this.agentServerHolder;
            synchronized (object) {
                sshAgentServer = (SshAgentServer)this.agentServerHolder.get();
                if (sshAgentServer != null) {
                    return sshAgentServer.getId();
                }
                sshAgentServer = Objects.requireNonNull(this.createSshAgentServer(this.serviceInstance, session), "No agent server created");
                this.agentServerHolder.set(sshAgentServer);
            }
            object = sshAgentServer.getId();
            if (this.log.isDebugEnabled()) {
                this.log.debug("initialize({}) id={}, server={}", new Object[]{session, object, sshAgentServer});
            }
            return object;
        }
        catch (Throwable throwable) {
            this.error("initialize({}) failed ({}) to create server: {}", session, throwable.getClass().getSimpleName(), throwable.getMessage(), throwable);
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new SshException(throwable);
        }
    }

    protected SshAgentServer createSshAgentServer(ConnectionService connectionService, Session session) {
        FactoryManager factoryManager = Objects.requireNonNull(session.getFactoryManager(), "No session factory manager");
        SshAgentFactory sshAgentFactory = Objects.requireNonNull(factoryManager.getAgentFactory(), "No agent factory");
        return sshAgentFactory.createServer(connectionService);
    }

    @Override
    public void close() {
        SshAgentServer sshAgentServer = this.agentServerHolder.getAndSet(null);
        if (sshAgentServer != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("close({}) closing server={}", (Object)this.serviceInstance.getSession(), (Object)sshAgentServer);
            }
            sshAgentServer.close();
        }
    }

    @Override
    protected void doCloseImmediately() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Failed (" + iOException.getClass().getSimpleName() + ") to close agent: " + iOException.getMessage(), iOException);
        }
        super.doCloseImmediately();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.serviceInstance.getSession() + "]";
    }
}

