/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.common;

import java.security.KeyPair;
import java.security.PublicKey;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentConstants;
import org.apache.sshd.agent.SshAgentKeyConstraint;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ExecutorServiceCarrier;

public abstract class AbstractAgentProxy
extends AbstractLoggingBean
implements SshAgent,
ExecutorServiceCarrier {
    private CloseableExecutorService executor;
    private String channelType = "auth-agent-req@openssh.com";

    protected AbstractAgentProxy(CloseableExecutorService closeableExecutorService) {
        this.executor = closeableExecutorService;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public void setChannelType(String string) {
        this.channelType = string;
    }

    @Override
    public CloseableExecutorService getExecutorService() {
        return this.executor;
    }

    @Override
    public Iterable getIdentities() {
        int n2 = 11;
        int n3 = 12;
        if ("auth-agent-req".equals(this.channelType)) {
            n2 = 204;
            n3 = 104;
        }
        Buffer buffer = this.createBuffer((byte)n2, 1);
        int n4 = (buffer = this.request(this.prepare(buffer))).getUByte();
        if (n4 != n3) {
            throw new SshException("Bad agent identities answer: " + SshAgentConstants.getCommandMessageName(n4));
        }
        int n5 = buffer.getInt();
        if (n5 < 0 || n5 > 1024) {
            throw new SshException("Illogical identities count: " + n5);
        }
        ArrayList<AbstractMap.SimpleImmutableEntry<PublicKey, String>> arrayList = new ArrayList<AbstractMap.SimpleImmutableEntry<PublicKey, String>>(n5);
        boolean bl2 = this.log.isDebugEnabled();
        for (int i2 = 0; i2 < n5; ++i2) {
            PublicKey publicKey = null;
            String string = null;
            try {
                publicKey = buffer.getPublicKey();
            }
            catch (SshException sshException) {
                string = sshException.getLocalizedMessage();
            }
            String string2 = buffer.getString();
            if (publicKey == null) {
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace("getIdentities() ignoring an unknown key type; comment={}; error={}", (Object)string2, (Object)string);
                continue;
            }
            if (bl2) {
                this.log.debug("getIdentities() key type={}, comment={}, fingerprint={}", new Object[]{KeyUtils.getKeyType(publicKey), string2, KeyUtils.getFingerPrint(publicKey)});
            }
            arrayList.add(new AbstractMap.SimpleImmutableEntry<PublicKey, String>(publicKey, string2));
        }
        return arrayList;
    }

    @Override
    public Map.Entry sign(SessionContext sessionContext, PublicKey publicKey, String string, byte[] byArray) {
        int n2 = 13;
        int n3 = 14;
        if ("auth-agent-req".equals(this.channelType)) {
            n2 = 205;
            n3 = 105;
        }
        Buffer buffer = this.createBuffer((byte)n2);
        String string2 = KeyUtils.getKeyType(publicKey);
        int n4 = 0;
        if ("auth-agent-req".equals(this.channelType)) {
            buffer.putString("sign");
        } else {
            String string3;
            if (!GenericUtils.isEmpty(string)) {
                if (!KeyUtils.getCanonicalKeyType(string).equals(string2)) {
                    throw new IllegalArgumentException("Bad signing request: signature algorithm '" + string + "' not applicable to '" + string2 + "' key");
                }
                string3 = string;
            } else {
                string3 = string2;
            }
            switch (string3) {
                case "rsa-sha2-512": 
                case "rsa-sha2-512-cert-v01@openssh.com": {
                    n4 = 4;
                    break;
                }
                case "rsa-sha2-256": 
                case "rsa-sha2-256-cert-v01@openssh.com": {
                    n4 = 2;
                    break;
                }
            }
        }
        buffer.putPublicKey(publicKey);
        buffer.putBytes(byArray);
        buffer.putInt(n4);
        buffer = this.request(this.prepare(buffer));
        int n5 = buffer.getUByte();
        if (n5 != n3) {
            throw new SshException("Bad signing response type: " + SshAgentConstants.getCommandMessageName(n5));
        }
        Object object = buffer.getBytes();
        int n6 = this.log.isDebugEnabled() ? 1 : 0;
        if ("auth-agent-req".equals(this.channelType)) {
            if (n6 != 0) {
                this.log.debug("sign({}/{})[{}] : {}", new Object[]{string, string2, KeyUtils.getFingerPrint(publicKey), BufferUtils.toHex(':', (byte[])object)});
            }
            return new AbstractMap.SimpleImmutableEntry<String, Object>(string2, object);
        }
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer((byte[])object);
        String string4 = byteArrayBuffer.getString();
        object = byteArrayBuffer.getBytes();
        if (n6 != 0) {
            this.log.debug("sign({}/{})[{}] {}: {}", new Object[]{string, string2, KeyUtils.getFingerPrint(publicKey), string4, BufferUtils.toHex(':', (byte[])object)});
        }
        return new AbstractMap.SimpleImmutableEntry<String, Object>(string4, object);
    }

    @Override
    public void addIdentity(KeyPair keyPair, String string, SshAgentKeyConstraint ... sshAgentKeyConstraintArray) {
        int n2;
        int n3;
        byte by = 17;
        if (!GenericUtils.isEmpty(sshAgentKeyConstraintArray)) {
            by = 25;
        }
        Buffer buffer = this.createBuffer(by);
        buffer.putKeyPair(keyPair);
        buffer.putString(string);
        if (!GenericUtils.isEmpty(sshAgentKeyConstraintArray)) {
            SshAgentKeyConstraint[] sshAgentKeyConstraintArray2 = sshAgentKeyConstraintArray;
            n3 = sshAgentKeyConstraintArray2.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                SshAgentKeyConstraint sshAgentKeyConstraint = sshAgentKeyConstraintArray2[i2];
                sshAgentKeyConstraint.put(buffer);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("addIdentity({})[{}]: {}", new Object[]{KeyUtils.getKeyType(keyPair), string, KeyUtils.getFingerPrint(keyPair.getPublic())});
        }
        int n4 = n3 = (n2 = (buffer = this.request(this.prepare(buffer))).available()) >= 1 ? buffer.getUByte() : -1;
        if (n2 != 1 || n3 != 6) {
            throw new SshException("Bad addIdentity response (" + SshAgentConstants.getCommandMessageName(n3) + ") - available=" + n2);
        }
    }

    @Override
    public void removeIdentity(PublicKey publicKey) {
        int n2;
        int n3;
        Buffer buffer = this.createBuffer((byte)18);
        buffer.putPublicKey(publicKey);
        if (this.log.isDebugEnabled()) {
            this.log.debug("removeIdentity({}) {}", (Object)KeyUtils.getKeyType(publicKey), (Object)KeyUtils.getFingerPrint(publicKey));
        }
        int n4 = n3 = (n2 = (buffer = this.request(this.prepare(buffer))).available()) >= 1 ? buffer.getUByte() : -1;
        if (n2 != 1 || n3 != 6) {
            throw new SshException("Bad removeIdentity response (" + SshAgentConstants.getCommandMessageName(n3) + ") - available=" + n2);
        }
    }

    @Override
    public void removeAllIdentities() {
        int n2;
        int n3;
        Buffer buffer = this.createBuffer((byte)19, 1);
        if (this.log.isDebugEnabled()) {
            this.log.debug("removeAllIdentities");
        }
        int n4 = n3 = (n2 = (buffer = this.request(this.prepare(buffer))).available()) >= 1 ? buffer.getUByte() : -1;
        if (n2 != 1 || n3 != 6) {
            throw new SshException("Bad removeAllIdentities response (" + SshAgentConstants.getCommandMessageName(n3) + ") - available=" + n2);
        }
    }

    @Override
    public void close() {
        CloseableExecutorService closeableExecutorService = this.getExecutorService();
        if (closeableExecutorService != null && !closeableExecutorService.isShutdown()) {
            List<Runnable> list = closeableExecutorService.shutdownNow();
            if (this.log.isDebugEnabled()) {
                this.log.debug("close() - shutdown runners count={}", (Object)GenericUtils.size(list));
            }
        }
    }

    protected Buffer createBuffer(byte by) {
        return this.createBuffer(by, 0);
    }

    protected Buffer createBuffer(byte by, int n2) {
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(n2 <= 0 ? 256 : n2 + 8, false);
        byteArrayBuffer.putUInt(0L);
        ((Buffer)byteArrayBuffer).putByte(by);
        return byteArrayBuffer;
    }

    protected Buffer prepare(Buffer buffer) {
        int n2 = buffer.wpos();
        buffer.wpos(0);
        buffer.putUInt(n2 - 4);
        buffer.wpos(n2);
        return buffer;
    }

    protected abstract Buffer request(Buffer var1);
}

