/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.common;

import java.io.StreamCorruptedException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentConstants;
import org.apache.sshd.agent.SshAgentKeyConstraint;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractAgentClient
extends AbstractLoggingBean {
    private final Buffer buffer = new ByteArrayBuffer();
    private final SshAgent agent;

    protected AbstractAgentClient(SshAgent sshAgent) {
        this.agent = sshAgent;
    }

    public synchronized void messageReceived(Buffer buffer) {
        this.buffer.putBuffer(buffer);
        int n2 = this.buffer.available();
        if (n2 < 4) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Received message total length ({}) below minimum ({})", (Object)n2, (Object)4);
            }
            return;
        }
        int n3 = this.buffer.rpos();
        int n4 = this.buffer.getInt();
        if (n4 < 0) {
            throw new StreamCorruptedException("Illogical message length: " + n4);
        }
        this.buffer.rpos(n3);
        n2 = this.buffer.available();
        if (n2 < n4 + 4) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Received request length ({}) below minimum ({})", (Object)n2, (Object)(n4 + 4));
            }
            return;
        }
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
        byteArrayBuffer.putUInt(0L);
        ((Buffer)byteArrayBuffer).rpos(((Buffer)byteArrayBuffer).wpos());
        ByteArrayBuffer byteArrayBuffer2 = new ByteArrayBuffer(this.buffer.getBytes());
        int n5 = -1;
        try {
            n5 = byteArrayBuffer2.getUByte();
            this.process(n5, byteArrayBuffer2, byteArrayBuffer);
        }
        catch (Exception exception) {
            this.debug("Failed ({}) to handle command={}: {}", exception.getClass().getSimpleName(), n5, exception.getMessage(), exception);
            byteArrayBuffer.clear();
            byteArrayBuffer.putUInt(0L);
            ((Buffer)byteArrayBuffer).rpos(((Buffer)byteArrayBuffer).wpos());
            byteArrayBuffer.putUInt(1L);
            ((Buffer)byteArrayBuffer).putByte((byte)30);
        }
        this.reply(this.prepare(byteArrayBuffer));
    }

    protected void process(int n2, Buffer buffer, Buffer buffer2) {
        boolean bl2 = this.log.isDebugEnabled();
        if (bl2) {
            this.log.debug("process(cmd={})", (Object)SshAgentConstants.getCommandMessageName(n2));
        }
        switch (n2) {
            case 11: {
                LinkedList linkedList;
                Iterable iterable = this.agent.getIdentities();
                if (iterable instanceof Collection) {
                    linkedList = (LinkedList)iterable;
                } else {
                    LinkedList linkedList2 = new LinkedList();
                    for (Map.Entry entry : iterable) {
                        linkedList2.add(entry);
                    }
                    linkedList = linkedList2;
                }
                buffer2.putByte((byte)12);
                buffer2.putUInt(linkedList.size());
                for (Object object : linkedList) {
                    buffer2.putPublicKey((PublicKey)object.getKey());
                    buffer2.putString((String)object.getValue());
                }
                break;
            }
            case 13: {
                String string;
                PublicKey publicKey = buffer.getPublicKey();
                byte[] byArray = buffer.getBytes();
                int n3 = buffer.getInt();
                if (bl2) {
                    this.log.debug("SSH2_AGENTC_SIGN_REQUEST key={}, flags=0x{}, data={}", new Object[]{publicKey.getAlgorithm(), Integer.toHexString(n3), BufferUtils.toHex(':', byArray)});
                }
                String string2 = string = ValidateUtils.checkNotNullAndNotEmpty(KeyUtils.getKeyType(publicKey), "Cannot resolve key type of %s", (Object)publicKey.getClass().getSimpleName());
                if ("ssh-rsa".equals(string)) {
                    switch (n3) {
                        case 4: {
                            string2 = "rsa-sha2-512";
                            break;
                        }
                        case 2: {
                            string2 = "rsa-sha2-256";
                            break;
                        }
                        case 0: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("SSH2_AGENTC_SIGN_REQUEST: Unknown flag value 0x" + Integer.toHexString(n3) + ", only 0, 2, or 4 are allowed.");
                        }
                    }
                }
                Map.Entry entry = this.agent.sign(null, publicKey, string2, byArray);
                String string3 = (String)entry.getKey();
                byte[] byArray2 = (byte[])entry.getValue();
                ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(string3.length() + byArray2.length + 64, false);
                byteArrayBuffer.putString(string3);
                byteArrayBuffer.putBytes(byArray2);
                buffer2.putByte((byte)14);
                buffer2.putBytes(((Buffer)byteArrayBuffer).array(), ((Buffer)byteArrayBuffer).rpos(), byteArrayBuffer.available());
                break;
            }
            case 17: {
                KeyPair keyPair = buffer.getKeyPair();
                String string = buffer.getString();
                if (bl2) {
                    this.log.debug("SSH2_AGENTC_ADD_IDENTITY comment={}", (Object)string);
                }
                this.agent.addIdentity(keyPair, string, new SshAgentKeyConstraint[0]);
                buffer2.putByte((byte)6);
                break;
            }
            case 18: {
                PublicKey publicKey = buffer.getPublicKey();
                if (bl2) {
                    this.log.debug("SSH2_AGENTC_REMOVE_IDENTITY {}", (Object)publicKey.getClass().getSimpleName());
                }
                this.agent.removeIdentity(publicKey);
                buffer2.putByte((byte)6);
                break;
            }
            case 19: {
                this.agent.removeAllIdentities();
                buffer2.putByte((byte)6);
                break;
            }
            default: {
                if (bl2) {
                    this.log.debug("Unknown command: {}", (Object)SshAgentConstants.getCommandMessageName(n2));
                }
                buffer2.putByte((byte)30);
            }
        }
    }

    protected Buffer prepare(Buffer buffer) {
        int n2 = buffer.available();
        int n3 = buffer.rpos();
        int n4 = buffer.wpos();
        buffer.rpos(n3 - 4);
        buffer.wpos(n3 - 4);
        buffer.putUInt(n2);
        buffer.wpos(n4);
        return buffer;
    }

    protected abstract void reply(Buffer var1);
}

