/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.serialization;

import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.io.serialization.ClassNameMatcher;
import org.apache.commons.io.serialization.FullClassNameMatcher;
import org.apache.commons.io.serialization.RegexpClassNameMatcher;
import org.apache.commons.io.serialization.WildcardClassNameMatcher;

public class ObjectStreamClassPredicate
implements Predicate {
    private final List acceptMatchers = new ArrayList();
    private final List rejectMatchers = new ArrayList();

    public ObjectStreamClassPredicate accept(Class ... classArray) {
        Stream.of(classArray).map(clazz -> new FullClassNameMatcher(clazz.getName())).forEach(this.acceptMatchers::add);
        return this;
    }

    public ObjectStreamClassPredicate accept(ClassNameMatcher classNameMatcher) {
        this.acceptMatchers.add(classNameMatcher);
        return this;
    }

    public ObjectStreamClassPredicate accept(Pattern pattern) {
        this.acceptMatchers.add(new RegexpClassNameMatcher(pattern));
        return this;
    }

    public ObjectStreamClassPredicate accept(String ... stringArray) {
        Stream.of(stringArray).map(WildcardClassNameMatcher::new).forEach(this.acceptMatchers::add);
        return this;
    }

    public ObjectStreamClassPredicate reject(Class ... classArray) {
        Stream.of(classArray).map(clazz -> new FullClassNameMatcher(clazz.getName())).forEach(this.rejectMatchers::add);
        return this;
    }

    public ObjectStreamClassPredicate reject(ClassNameMatcher classNameMatcher) {
        this.rejectMatchers.add(classNameMatcher);
        return this;
    }

    public ObjectStreamClassPredicate reject(Pattern pattern) {
        this.rejectMatchers.add(new RegexpClassNameMatcher(pattern));
        return this;
    }

    public ObjectStreamClassPredicate reject(String ... stringArray) {
        Stream.of(stringArray).map(WildcardClassNameMatcher::new).forEach(this.rejectMatchers::add);
        return this;
    }

    public boolean test(ObjectStreamClass objectStreamClass) {
        return this.test(objectStreamClass.getName());
    }

    public boolean test(String string) {
        for (ClassNameMatcher classNameMatcher : this.rejectMatchers) {
            if (!classNameMatcher.matches(string)) continue;
            return false;
        }
        for (ClassNameMatcher classNameMatcher : this.acceptMatchers) {
            if (!classNameMatcher.matches(string)) continue;
            return true;
        }
        return false;
    }
}

