/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.charset.CharsetDecoders;
import org.apache.commons.io.output.WriterOutputStream$Builder;

public class WriterOutputStream
extends OutputStream {
    private static final int BUFFER_SIZE = 8192;
    private final Writer writer;
    private final CharsetDecoder decoder;
    private final boolean writeImmediately;
    private final ByteBuffer decoderIn = ByteBuffer.allocate(128);
    private final CharBuffer decoderOut;

    public static WriterOutputStream$Builder builder() {
        return new WriterOutputStream$Builder();
    }

    private static void checkIbmJdkWithBrokenUTF16(Charset charset) {
        if (!StandardCharsets.UTF_16.name().equals(charset.name())) {
            return;
        }
        String string = "v\u00e9s";
        byte[] byArray = "v\u00e9s".getBytes(charset);
        CharsetDecoder charsetDecoder = charset.newDecoder();
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        CharBuffer charBuffer = CharBuffer.allocate("v\u00e9s".length());
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            byteBuffer.put(byArray[i2]);
            byteBuffer.flip();
            try {
                charsetDecoder.decode(byteBuffer, charBuffer, i2 == n2 - 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new UnsupportedOperationException("UTF-16 requested when running on an IBM JDK with broken UTF-16 support. Please find a JDK that supports UTF-16 if you intend to use UF-16 with WriterOutputStream");
            }
            byteBuffer.compact();
        }
        charBuffer.rewind();
        if (!"v\u00e9s".equals(charBuffer.toString())) {
            throw new UnsupportedOperationException("UTF-16 requested when running on an IBM JDK with broken UTF-16 support. Please find a JDK that supports UTF-16 if you intend to use UF-16 with WriterOutputStream");
        }
    }

    @Deprecated
    public WriterOutputStream(Writer writer) {
        this(writer, Charset.defaultCharset(), 8192, false);
    }

    @Deprecated
    public WriterOutputStream(Writer writer, Charset charset) {
        this(writer, charset, 8192, false);
    }

    @Deprecated
    public WriterOutputStream(Writer writer, Charset charset, int n2, boolean bl2) {
        this(writer, Charsets.toCharset(charset).newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?"), n2, bl2);
    }

    @Deprecated
    public WriterOutputStream(Writer writer, CharsetDecoder charsetDecoder) {
        this(writer, charsetDecoder, 8192, false);
    }

    @Deprecated
    public WriterOutputStream(Writer writer, CharsetDecoder charsetDecoder, int n2, boolean bl2) {
        WriterOutputStream.checkIbmJdkWithBrokenUTF16(CharsetDecoders.toCharsetDecoder(charsetDecoder).charset());
        this.writer = writer;
        this.decoder = CharsetDecoders.toCharsetDecoder(charsetDecoder);
        this.writeImmediately = bl2;
        this.decoderOut = CharBuffer.allocate(n2);
    }

    @Deprecated
    public WriterOutputStream(Writer writer, String string) {
        this(writer, string, 8192, false);
    }

    @Deprecated
    public WriterOutputStream(Writer writer, String string, int n2, boolean bl2) {
        this(writer, Charsets.toCharset(string), n2, bl2);
    }

    @Override
    public void close() {
        this.processInput(true);
        this.flushOutput();
        this.writer.close();
    }

    @Override
    public void flush() {
        this.flushOutput();
        this.writer.flush();
    }

    private void flushOutput() {
        if (this.decoderOut.position() > 0) {
            this.writer.write(this.decoderOut.array(), 0, this.decoderOut.position());
            this.decoderOut.rewind();
        }
    }

    private void processInput(boolean bl2) {
        CoderResult coderResult;
        this.decoderIn.flip();
        while ((coderResult = this.decoder.decode(this.decoderIn, this.decoderOut, bl2)).isOverflow()) {
            this.flushOutput();
        }
        if (!coderResult.isUnderflow()) {
            throw new IOException("Unexpected coder result");
        }
        this.decoderIn.compact();
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        while (n3 > 0) {
            int n4 = Math.min(n3, this.decoderIn.remaining());
            this.decoderIn.put(byArray, n2, n4);
            this.processInput(false);
            n3 -= n4;
            n2 += n4;
        }
        if (this.writeImmediately) {
            this.flushOutput();
        }
    }

    @Override
    public void write(int n2) {
        this.write(new byte[]{(byte)n2}, 0, 1);
    }
}

