/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.function.Uncheck;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.commons.io.output.AbstractByteArrayOutputStream;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream$Builder;

public final class UnsynchronizedByteArrayOutputStream
extends AbstractByteArrayOutputStream {
    public static UnsynchronizedByteArrayOutputStream$Builder builder() {
        return new UnsynchronizedByteArrayOutputStream$Builder();
    }

    public static InputStream toBufferedInputStream(InputStream inputStream) {
        return UnsynchronizedByteArrayOutputStream.toBufferedInputStream(inputStream, 1024);
    }

    public static InputStream toBufferedInputStream(InputStream inputStream, int n2) {
        try (UnsynchronizedByteArrayOutputStream unsynchronizedByteArrayOutputStream = ((UnsynchronizedByteArrayOutputStream$Builder)UnsynchronizedByteArrayOutputStream.builder().setBufferSize(n2)).get();){
            unsynchronizedByteArrayOutputStream.write(inputStream);
            InputStream inputStream2 = unsynchronizedByteArrayOutputStream.toInputStream();
            return inputStream2;
        }
    }

    @Deprecated
    public UnsynchronizedByteArrayOutputStream() {
        this(1024);
    }

    @Deprecated
    public UnsynchronizedByteArrayOutputStream(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n2);
        }
        this.needNewBuffer(n2);
    }

    @Override
    public void reset() {
        this.resetImpl();
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArrayImpl();
    }

    @Override
    public InputStream toInputStream() {
        return this.toInputStream((byArray, n2, n3) -> (UnsynchronizedByteArrayInputStream)Uncheck.get(() -> UnsynchronizedByteArrayInputStream.builder().setByteArray(byArray).setOffset(n2).setLength(n3).get()));
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException(String.format("offset=%,d, length=%,d", n2, n3));
        }
        if (n3 == 0) {
            return;
        }
        this.writeImpl(byArray, n2, n3);
    }

    @Override
    public int write(InputStream inputStream) {
        return this.writeImpl(inputStream);
    }

    @Override
    public void write(int n2) {
        this.writeImpl(n2);
    }

    @Override
    public void writeTo(OutputStream outputStream) {
        this.writeToImpl(outputStream);
    }
}

