/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class ProxyOutputStream
extends FilterOutputStream {
    public ProxyOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    protected void afterWrite(int n2) {
    }

    protected void beforeWrite(int n2) {
    }

    @Override
    public void close() {
        IOUtils.close((Closeable)this.out, this::handleIOException);
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    protected void handleIOException(IOException iOException) {
        throw iOException;
    }

    @Override
    public void write(byte[] byArray) {
        try {
            int n2 = IOUtils.length(byArray);
            this.beforeWrite(n2);
            this.out.write(byArray);
            this.afterWrite(n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        try {
            this.beforeWrite(n3);
            this.out.write(byArray, n2, n3);
            this.afterWrite(n3);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void write(int n2) {
        try {
            this.beforeWrite(1);
            this.out.write(n2);
            this.afterWrite(1);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }
}

