/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.LockableFileWriter$Builder;

public class LockableFileWriter
extends Writer {
    private static final String LCK = ".lck";
    private final Writer out;
    private final File lockFile;

    public static LockableFileWriter$Builder builder() {
        return new LockableFileWriter$Builder();
    }

    @Deprecated
    public LockableFileWriter(File file) {
        this(file, false, null);
    }

    @Deprecated
    public LockableFileWriter(File file, boolean bl2) {
        this(file, bl2, null);
    }

    @Deprecated
    public LockableFileWriter(File file, boolean bl2, String string) {
        this(file, Charset.defaultCharset(), bl2, string);
    }

    @Deprecated
    public LockableFileWriter(File file, Charset charset) {
        this(file, charset, false, null);
    }

    @Deprecated
    public LockableFileWriter(File file, Charset charset, boolean bl2, String string) {
        File file2 = Objects.requireNonNull(file, "file").getAbsoluteFile();
        if (file2.getParentFile() != null) {
            FileUtils.forceMkdir(file2.getParentFile());
        }
        if (file2.isDirectory()) {
            throw new IOException("File specified is a directory");
        }
        File file3 = new File(string != null ? string : FileUtils.getTempDirectoryPath());
        FileUtils.forceMkdir(file3);
        this.testLockDir(file3);
        this.lockFile = new File(file3, file2.getName() + LCK);
        this.createLock();
        this.out = this.initWriter(file2, charset, bl2);
    }

    @Deprecated
    public LockableFileWriter(File file, String string) {
        this(file, string, false, null);
    }

    @Deprecated
    public LockableFileWriter(File file, String string, boolean bl2, String string2) {
        this(file, Charsets.toCharset(string), bl2, string2);
    }

    @Deprecated
    public LockableFileWriter(String string) {
        this(string, false, null);
    }

    @Deprecated
    public LockableFileWriter(String string, boolean bl2) {
        this(string, bl2, null);
    }

    @Deprecated
    public LockableFileWriter(String string, boolean bl2, String string2) {
        this(new File(string), bl2, string2);
    }

    @Override
    public void close() {
        try {
            this.out.close();
        }
        finally {
            FileUtils.delete(this.lockFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLock() {
        Class<LockableFileWriter> clazz = LockableFileWriter.class;
        synchronized (LockableFileWriter.class) {
            if (!this.lockFile.createNewFile()) {
                throw new IOException("Can't write file, lock " + this.lockFile.getAbsolutePath() + " exists");
            }
            this.lockFile.deleteOnExit();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    private Writer initWriter(File file, Charset charset, boolean bl2) {
        boolean bl3 = file.exists();
        try {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(file.getAbsolutePath(), bl2), Charsets.toCharset(charset));
        }
        catch (IOException | RuntimeException exception) {
            FileUtils.deleteQuietly(this.lockFile);
            if (!bl3) {
                FileUtils.deleteQuietly(file);
            }
            throw exception;
        }
    }

    private void testLockDir(File file) {
        if (!file.exists()) {
            throw new IOException("Could not find lockDir: " + file.getAbsolutePath());
        }
        if (!file.canWrite()) {
            throw new IOException("Could not write to lockDir: " + file.getAbsolutePath());
        }
    }

    @Override
    public void write(char[] cArray) {
        this.out.write(cArray);
    }

    @Override
    public void write(char[] cArray, int n2, int n3) {
        this.out.write(cArray, n2, n3);
    }

    @Override
    public void write(int n2) {
        this.out.write(n2);
    }

    @Override
    public void write(String string) {
        this.out.write(string);
    }

    @Override
    public void write(String string, int n2, int n3) {
        this.out.write(string, n2, n3);
    }
}

