/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.io.function.IOConsumer;

public class FilterCollectionWriter
extends Writer {
    protected final Collection EMPTY_WRITERS = Collections.emptyList();
    protected final Collection writers;

    protected FilterCollectionWriter(Collection collection) {
        this.writers = collection == null ? this.EMPTY_WRITERS : collection;
    }

    protected FilterCollectionWriter(Writer ... writerArray) {
        this.writers = writerArray == null ? this.EMPTY_WRITERS : Arrays.asList(writerArray);
    }

    @Override
    public Writer append(char c2) {
        return this.forAllWriters(writer -> writer.append(c2));
    }

    @Override
    public Writer append(CharSequence charSequence) {
        return this.forAllWriters(writer -> writer.append(charSequence));
    }

    @Override
    public Writer append(CharSequence charSequence, int n2, int n3) {
        return this.forAllWriters(writer -> writer.append(charSequence, n2, n3));
    }

    @Override
    public void close() {
        this.forAllWriters(Writer::close);
    }

    @Override
    public void flush() {
        this.forAllWriters(Writer::flush);
    }

    private FilterCollectionWriter forAllWriters(IOConsumer iOConsumer) {
        IOConsumer.forAll(iOConsumer, this.writers());
        return this;
    }

    @Override
    public void write(char[] cArray) {
        this.forAllWriters(writer -> writer.write(cArray));
    }

    @Override
    public void write(char[] cArray, int n2, int n3) {
        this.forAllWriters(writer -> writer.write(cArray, n2, n3));
    }

    @Override
    public void write(int n2) {
        this.forAllWriters(writer -> writer.write(n2));
    }

    @Override
    public void write(String string) {
        this.forAllWriters(writer -> writer.write(string));
    }

    @Override
    public void write(String string, int n2, int n3) {
        this.forAllWriters(writer -> writer.write(string, n2, n3));
    }

    private Stream writers() {
        return this.writers.stream().filter(Objects::nonNull);
    }
}

