/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.DeferredFileOutputStream$1;
import org.apache.commons.io.output.DeferredFileOutputStream$Builder;
import org.apache.commons.io.output.ThresholdingOutputStream;

public class DeferredFileOutputStream
extends ThresholdingOutputStream {
    private ByteArrayOutputStream memoryOutputStream;
    private OutputStream currentOutputStream;
    private Path outputPath;
    private final String prefix;
    private final String suffix;
    private final Path directory;
    private boolean closed;

    public static DeferredFileOutputStream$Builder builder() {
        return new DeferredFileOutputStream$Builder();
    }

    private static int checkBufferSize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Initial buffer size must be at least 0.");
        }
        return n2;
    }

    private static Path toPath(File file, Supplier supplier) {
        return file != null ? file.toPath() : (supplier == null ? null : (Path)supplier.get());
    }

    private static Path toPath(Path path, Supplier supplier) {
        return path != null ? path : (supplier == null ? null : (Path)supplier.get());
    }

    @Deprecated
    public DeferredFileOutputStream(int n2, File file) {
        this(n2, file, null, null, null, 1024);
    }

    private DeferredFileOutputStream(int n2, File file, String string, String string2, File file2, int n3) {
        super(n2);
        this.outputPath = DeferredFileOutputStream.toPath(file, null);
        this.prefix = string;
        this.suffix = string2;
        this.directory = DeferredFileOutputStream.toPath(file2, PathUtils::getTempDirectory);
        this.memoryOutputStream = new ByteArrayOutputStream(DeferredFileOutputStream.checkBufferSize(n3));
        this.currentOutputStream = this.memoryOutputStream;
    }

    @Deprecated
    public DeferredFileOutputStream(int n2, int n3, File file) {
        this(n2, file, null, null, null, n3);
    }

    @Deprecated
    public DeferredFileOutputStream(int n2, int n3, String string, String string2, File file) {
        this(n2, null, Objects.requireNonNull(string, "prefix"), string2, file, n3);
    }

    private DeferredFileOutputStream(int n2, Path path, String string, String string2, Path path2, int n3) {
        super(n2);
        this.outputPath = DeferredFileOutputStream.toPath(path, null);
        this.prefix = string;
        this.suffix = string2;
        this.directory = DeferredFileOutputStream.toPath(path2, PathUtils::getTempDirectory);
        this.memoryOutputStream = new ByteArrayOutputStream(DeferredFileOutputStream.checkBufferSize(n3));
        this.currentOutputStream = this.memoryOutputStream;
    }

    @Deprecated
    public DeferredFileOutputStream(int n2, String string, String string2, File file) {
        this(n2, null, Objects.requireNonNull(string, "prefix"), string2, file, 1024);
    }

    @Override
    public void close() {
        super.close();
        this.closed = true;
    }

    public byte[] getData() {
        return this.memoryOutputStream != null ? this.memoryOutputStream.toByteArray() : null;
    }

    public File getFile() {
        return this.outputPath != null ? this.outputPath.toFile() : null;
    }

    public Path getPath() {
        return this.outputPath;
    }

    @Override
    protected OutputStream getStream() {
        return this.currentOutputStream;
    }

    public boolean isInMemory() {
        return !this.isThresholdExceeded();
    }

    @Override
    protected void thresholdReached() {
        if (this.prefix != null) {
            this.outputPath = Files.createTempFile(this.directory, this.prefix, this.suffix, new FileAttribute[0]);
        }
        PathUtils.createParentDirectories(this.outputPath, null, PathUtils.EMPTY_FILE_ATTRIBUTE_ARRAY);
        OutputStream outputStream = Files.newOutputStream(this.outputPath, new OpenOption[0]);
        try {
            this.memoryOutputStream.writeTo(outputStream);
        }
        catch (IOException iOException) {
            outputStream.close();
            throw iOException;
        }
        this.currentOutputStream = outputStream;
        this.memoryOutputStream = null;
    }

    public InputStream toInputStream() {
        if (!this.closed) {
            throw new IOException("Stream not closed");
        }
        if (this.isInMemory()) {
            return this.memoryOutputStream.toInputStream();
        }
        return Files.newInputStream(this.outputPath, new OpenOption[0]);
    }

    public void writeTo(OutputStream outputStream) {
        if (!this.closed) {
            throw new IOException("Stream not closed");
        }
        if (this.isInMemory()) {
            this.memoryOutputStream.writeTo(outputStream);
        } else {
            Files.copy(this.outputPath, outputStream);
        }
    }

    /* synthetic */ DeferredFileOutputStream(int n2, Path path, String string, String string2, Path path2, int n3, DeferredFileOutputStream$1 deferredFileOutputStream$1) {
        this(n2, path, string, string2, path2, n3);
    }

    static /* synthetic */ Path access$100(File file, Supplier supplier) {
        return DeferredFileOutputStream.toPath(file, supplier);
    }

    static /* synthetic */ Path access$200(Path path, Supplier supplier) {
        return DeferredFileOutputStream.toPath(path, supplier);
    }
}

