/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.FilterWriter;
import java.io.Writer;

public class ChunkedWriter
extends FilterWriter {
    private static final int DEFAULT_CHUNK_SIZE = 8192;
    private final int chunkSize;

    public ChunkedWriter(Writer writer) {
        this(writer, 8192);
    }

    public ChunkedWriter(Writer writer, int n2) {
        super(writer);
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.chunkSize = n2;
    }

    @Override
    public void write(char[] cArray, int n2, int n3) {
        int n4 = n3;
        int n5 = n2;
        while (n4 > 0) {
            int n6 = Math.min(n4, this.chunkSize);
            this.out.write(cArray, n5, n6);
            n4 -= n6;
            n5 += n6;
        }
    }
}

