/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.AbstractByteArrayOutputStream;

public class ByteArrayOutputStream
extends AbstractByteArrayOutputStream {
    public static InputStream toBufferedInputStream(InputStream inputStream) {
        return ByteArrayOutputStream.toBufferedInputStream(inputStream, 1024);
    }

    public static InputStream toBufferedInputStream(InputStream inputStream, int n2) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);){
            byteArrayOutputStream.write(inputStream);
            InputStream inputStream2 = byteArrayOutputStream.toInputStream();
            return inputStream2;
        }
    }

    public ByteArrayOutputStream() {
        this(1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n2);
        }
        ByteArrayOutputStream byteArrayOutputStream = this;
        synchronized (byteArrayOutputStream) {
            this.needNewBuffer(n2);
        }
    }

    @Override
    public synchronized void reset() {
        this.resetImpl();
    }

    @Override
    public synchronized int size() {
        return this.count;
    }

    @Override
    public synchronized byte[] toByteArray() {
        return this.toByteArrayImpl();
    }

    @Override
    public synchronized InputStream toInputStream() {
        return this.toInputStream(ByteArrayInputStream::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = this;
        synchronized (byteArrayOutputStream) {
            this.writeImpl(byArray, n2, n3);
        }
    }

    @Override
    public synchronized int write(InputStream inputStream) {
        return this.writeImpl(inputStream);
    }

    @Override
    public synchronized void write(int n2) {
        this.writeImpl(n2);
    }

    @Override
    public synchronized void writeTo(OutputStream outputStream) {
        this.writeToImpl(outputStream);
    }
}

