/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.Writer;
import java.util.Objects;

public class AppendableWriter
extends Writer {
    private final Appendable appendable;

    public AppendableWriter(Appendable appendable) {
        this.appendable = appendable;
    }

    @Override
    public Writer append(char c2) {
        this.appendable.append(c2);
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence) {
        this.appendable.append(charSequence);
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int n2, int n3) {
        this.appendable.append(charSequence, n2, n3);
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    public Appendable getAppendable() {
        return this.appendable;
    }

    @Override
    public void write(char[] cArray, int n2, int n3) {
        Objects.requireNonNull(cArray, "cbuf");
        if (n3 < 0 || n2 + n3 > cArray.length) {
            throw new IndexOutOfBoundsException("Array Size=" + cArray.length + ", offset=" + n2 + ", length=" + n3);
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            this.appendable.append(cArray[n2 + i2]);
        }
    }

    @Override
    public void write(int n2) {
        this.appendable.append((char)n2);
    }

    @Override
    public void write(String string, int n2, int n3) {
        Objects.requireNonNull(string, "str");
        this.appendable.append(string, n2, n2 + n3);
    }
}

