/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ClosedInputStream;
import org.apache.commons.io.output.AbstractByteArrayOutputStream$InputStreamConstructor;

public abstract class AbstractByteArrayOutputStream
extends OutputStream {
    static final int DEFAULT_SIZE = 1024;
    private final List buffers = new ArrayList();
    private int currentBufferIndex;
    private int filledBufferSum;
    private byte[] currentBuffer;
    protected int count;
    private boolean reuseBuffers = true;

    @Override
    public void close() {
    }

    protected void needNewBuffer(int n2) {
        if (this.currentBufferIndex < this.buffers.size() - 1) {
            this.filledBufferSum += this.currentBuffer.length;
            ++this.currentBufferIndex;
            this.currentBuffer = (byte[])this.buffers.get(this.currentBufferIndex);
        } else {
            int n3;
            if (this.currentBuffer == null) {
                n3 = n2;
                this.filledBufferSum = 0;
            } else {
                n3 = Math.max(this.currentBuffer.length << 1, n2 - this.filledBufferSum);
                this.filledBufferSum += this.currentBuffer.length;
            }
            ++this.currentBufferIndex;
            this.currentBuffer = IOUtils.byteArray(n3);
            this.buffers.add(this.currentBuffer);
        }
    }

    public abstract void reset();

    protected void resetImpl() {
        this.count = 0;
        this.filledBufferSum = 0;
        this.currentBufferIndex = 0;
        if (this.reuseBuffers) {
            this.currentBuffer = (byte[])this.buffers.get(this.currentBufferIndex);
        } else {
            this.currentBuffer = null;
            int n2 = ((byte[])this.buffers.get(0)).length;
            this.buffers.clear();
            this.needNewBuffer(n2);
            this.reuseBuffers = true;
        }
    }

    public abstract int size();

    public abstract byte[] toByteArray();

    protected byte[] toByteArrayImpl() {
        int n2 = this.count;
        if (n2 == 0) {
            return IOUtils.EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = IOUtils.byteArray(n2);
        int n3 = 0;
        for (byte[] byArray2 : this.buffers) {
            int n4 = Math.min(byArray2.length, n2);
            System.arraycopy(byArray2, 0, byArray, n3, n4);
            n3 += n4;
            if ((n2 -= n4) != 0) continue;
            break;
        }
        return byArray;
    }

    public abstract InputStream toInputStream();

    protected InputStream toInputStream(AbstractByteArrayOutputStream$InputStreamConstructor abstractByteArrayOutputStream$InputStreamConstructor) {
        int n2 = this.count;
        if (n2 == 0) {
            return ClosedInputStream.INSTANCE;
        }
        ArrayList<InputStream> arrayList = new ArrayList<InputStream>(this.buffers.size());
        for (byte[] byArray : this.buffers) {
            int n3 = Math.min(byArray.length, n2);
            arrayList.add(abstractByteArrayOutputStream$InputStreamConstructor.construct(byArray, 0, n3));
            if ((n2 -= n3) != 0) continue;
            break;
        }
        this.reuseBuffers = false;
        return new SequenceInputStream(Collections.enumeration(arrayList));
    }

    @Deprecated
    public String toString() {
        return new String(this.toByteArray(), Charset.defaultCharset());
    }

    public String toString(Charset charset) {
        return new String(this.toByteArray(), charset);
    }

    public String toString(String string) {
        return new String(this.toByteArray(), string);
    }

    @Override
    public abstract void write(byte[] var1, int var2, int var3);

    public abstract int write(InputStream var1);

    @Override
    public abstract void write(int var1);

    protected void writeImpl(byte[] byArray, int n2, int n3) {
        int n4 = this.count + n3;
        int n5 = n3;
        int n6 = this.count - this.filledBufferSum;
        while (n5 > 0) {
            int n7 = Math.min(n5, this.currentBuffer.length - n6);
            System.arraycopy(byArray, n2 + n3 - n5, this.currentBuffer, n6, n7);
            if ((n5 -= n7) <= 0) continue;
            this.needNewBuffer(n4);
            n6 = 0;
        }
        this.count = n4;
    }

    protected int writeImpl(InputStream inputStream) {
        int n2 = 0;
        int n3 = this.count - this.filledBufferSum;
        int n4 = inputStream.read(this.currentBuffer, n3, this.currentBuffer.length - n3);
        while (n4 != -1) {
            n2 += n4;
            this.count += n4;
            if ((n3 += n4) == this.currentBuffer.length) {
                this.needNewBuffer(this.currentBuffer.length);
                n3 = 0;
            }
            n4 = inputStream.read(this.currentBuffer, n3, this.currentBuffer.length - n3);
        }
        return n2;
    }

    protected void writeImpl(int n2) {
        int n3 = this.count - this.filledBufferSum;
        if (n3 == this.currentBuffer.length) {
            this.needNewBuffer(this.count + 1);
            n3 = 0;
        }
        this.currentBuffer[n3] = (byte)n2;
        ++this.count;
    }

    public abstract void writeTo(OutputStream var1);

    protected void writeToImpl(OutputStream outputStream) {
        int n2 = this.count;
        for (byte[] byArray : this.buffers) {
            int n3 = Math.min(byArray.length, n2);
            outputStream.write(byArray, 0, n3);
            if ((n2 -= n3) != 0) continue;
            break;
        }
    }
}

