/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.file.attribute.FileTimes;

final class SerializableFileTime
implements Serializable {
    static final SerializableFileTime EPOCH = new SerializableFileTime(FileTimes.EPOCH);
    private static final long serialVersionUID = 1L;
    private FileTime fileTime;

    public SerializableFileTime(FileTime fileTime) {
        this.fileTime = Objects.requireNonNull(fileTime);
    }

    public int compareTo(FileTime fileTime) {
        return this.fileTime.compareTo(fileTime);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SerializableFileTime)) {
            return false;
        }
        SerializableFileTime serializableFileTime = (SerializableFileTime)object;
        return Objects.equals(this.fileTime, serializableFileTime.fileTime);
    }

    public int hashCode() {
        return this.fileTime.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) {
        this.fileTime = FileTime.from((Instant)objectInputStream.readObject());
    }

    long to(TimeUnit timeUnit) {
        return this.fileTime.to(timeUnit);
    }

    Instant toInstant() {
        return this.fileTime.toInstant();
    }

    long toMillis() {
        return this.fileTime.toMillis();
    }

    public String toString() {
        return this.fileTime.toString();
    }

    FileTime unwrap() {
        return this.fileTime;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeObject(this.fileTime.toInstant());
    }
}

