/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.file.attribute.FileTimes;
import org.apache.commons.io.monitor.SerializableFileTime;

public class FileEntry
implements Serializable {
    private static final long serialVersionUID = -2505664948818681153L;
    static final FileEntry[] EMPTY_FILE_ENTRY_ARRAY = new FileEntry[0];
    private final FileEntry parent;
    private FileEntry[] children;
    private final File file;
    private String name;
    private boolean exists;
    private boolean directory;
    private SerializableFileTime lastModified = SerializableFileTime.EPOCH;
    private long length;

    public FileEntry(File file) {
        this(null, file);
    }

    public FileEntry(FileEntry fileEntry, File file) {
        this.file = Objects.requireNonNull(file, "file");
        this.parent = fileEntry;
        this.name = file.getName();
    }

    public FileEntry[] getChildren() {
        return this.children != null ? this.children : EMPTY_FILE_ENTRY_ARRAY;
    }

    public File getFile() {
        return this.file;
    }

    public long getLastModified() {
        return this.lastModified.toMillis();
    }

    public FileTime getLastModifiedFileTime() {
        return this.lastModified.unwrap();
    }

    public long getLength() {
        return this.length;
    }

    public int getLevel() {
        return this.parent == null ? 0 : this.parent.getLevel() + 1;
    }

    public String getName() {
        return this.name;
    }

    public FileEntry getParent() {
        return this.parent;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public boolean isExists() {
        return this.exists;
    }

    public FileEntry newChildInstance(File file) {
        return new FileEntry(this, file);
    }

    public boolean refresh(File file) {
        boolean bl2 = this.exists;
        SerializableFileTime serializableFileTime = this.lastModified;
        boolean bl3 = this.directory;
        long l2 = this.length;
        this.name = file.getName();
        this.exists = Files.exists(file.toPath(), new LinkOption[0]);
        this.directory = this.exists && file.isDirectory();
        try {
            this.setLastModified(this.exists ? FileUtils.lastModifiedFileTime(file) : FileTimes.EPOCH);
        }
        catch (IOException iOException) {
            this.setLastModified(SerializableFileTime.EPOCH);
        }
        this.length = this.exists && !this.directory ? file.length() : 0L;
        return this.exists != bl2 || !this.lastModified.equals(serializableFileTime) || this.directory != bl3 || this.length != l2;
    }

    public void setChildren(FileEntry ... fileEntryArray) {
        this.children = fileEntryArray;
    }

    public void setDirectory(boolean bl2) {
        this.directory = bl2;
    }

    public void setExists(boolean bl2) {
        this.exists = bl2;
    }

    public void setLastModified(FileTime fileTime) {
        this.setLastModified(new SerializableFileTime(fileTime));
    }

    public void setLastModified(long l2) {
        this.setLastModified(FileTime.fromMillis(l2));
    }

    void setLastModified(SerializableFileTime serializableFileTime) {
        this.lastModified = serializableFileTime;
    }

    public void setLength(long l2) {
        this.length = l2;
    }

    public void setName(String string) {
        this.name = string;
    }
}

