/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationObserver$1;
import org.apache.commons.io.monitor.FileAlterationObserver$Builder;
import org.apache.commons.io.monitor.FileEntry;

public class FileAlterationObserver
implements Serializable {
    private static final long serialVersionUID = 1185122225658782848L;
    private final transient List listeners = new CopyOnWriteArrayList();
    private final FileEntry rootEntry;
    private final transient FileFilter fileFilter;
    private final Comparator comparator;

    public static FileAlterationObserver$Builder builder() {
        return new FileAlterationObserver$Builder(null);
    }

    private static Comparator toComparator(IOCase iOCase) {
        switch (IOCase.value(iOCase, IOCase.SYSTEM)) {
            case SYSTEM: {
                return NameFileComparator.NAME_SYSTEM_COMPARATOR;
            }
            case INSENSITIVE: {
                return NameFileComparator.NAME_INSENSITIVE_COMPARATOR;
            }
        }
        return NameFileComparator.NAME_COMPARATOR;
    }

    @Deprecated
    public FileAlterationObserver(File file) {
        this(file, null);
    }

    @Deprecated
    public FileAlterationObserver(File file, FileFilter fileFilter) {
        this(file, fileFilter, null);
    }

    @Deprecated
    public FileAlterationObserver(File file, FileFilter fileFilter, IOCase iOCase) {
        this(new FileEntry(file), fileFilter, iOCase);
    }

    private FileAlterationObserver(FileEntry fileEntry, FileFilter fileFilter, Comparator comparator) {
        Objects.requireNonNull(fileEntry, "rootEntry");
        Objects.requireNonNull(fileEntry.getFile(), "rootEntry.getFile()");
        this.rootEntry = fileEntry;
        this.fileFilter = fileFilter != null ? fileFilter : TrueFileFilter.INSTANCE;
        this.comparator = Objects.requireNonNull(comparator, "comparator");
    }

    protected FileAlterationObserver(FileEntry fileEntry, FileFilter fileFilter, IOCase iOCase) {
        this(fileEntry, fileFilter, FileAlterationObserver.toComparator(iOCase));
    }

    @Deprecated
    public FileAlterationObserver(String string) {
        this(new File(string));
    }

    @Deprecated
    public FileAlterationObserver(String string, FileFilter fileFilter) {
        this(new File(string), fileFilter);
    }

    @Deprecated
    public FileAlterationObserver(String string, FileFilter fileFilter, IOCase iOCase) {
        this(new File(string), fileFilter, iOCase);
    }

    public void addListener(FileAlterationListener fileAlterationListener) {
        if (fileAlterationListener != null) {
            this.listeners.add(fileAlterationListener);
        }
    }

    private void checkAndFire(FileEntry fileEntry, FileEntry[] fileEntryArray, File[] fileArray) {
        int n2 = 0;
        FileEntry[] fileEntryArray2 = fileArray.length > 0 ? new FileEntry[fileArray.length] : FileEntry.EMPTY_FILE_ENTRY_ARRAY;
        for (FileEntry fileEntry2 : fileEntryArray) {
            while (n2 < fileArray.length && this.comparator.compare(fileEntry2.getFile(), fileArray[n2]) > 0) {
                fileEntryArray2[n2] = this.createFileEntry(fileEntry, fileArray[n2]);
                this.fireOnCreate(fileEntryArray2[n2]);
                ++n2;
            }
            if (n2 < fileArray.length && this.comparator.compare(fileEntry2.getFile(), fileArray[n2]) == 0) {
                this.fireOnChange(fileEntry2, fileArray[n2]);
                this.checkAndFire(fileEntry2, fileEntry2.getChildren(), this.listFiles(fileArray[n2]));
                fileEntryArray2[n2] = fileEntry2;
                ++n2;
                continue;
            }
            this.checkAndFire(fileEntry2, fileEntry2.getChildren(), FileUtils.EMPTY_FILE_ARRAY);
            this.fireOnDelete(fileEntry2);
        }
        while (n2 < fileArray.length) {
            fileEntryArray2[n2] = this.createFileEntry(fileEntry, fileArray[n2]);
            this.fireOnCreate(fileEntryArray2[n2]);
            ++n2;
        }
        fileEntry.setChildren(fileEntryArray2);
    }

    public void checkAndNotify() {
        this.listeners.forEach(fileAlterationListener -> fileAlterationListener.onStart(this));
        File file = this.rootEntry.getFile();
        if (file.exists()) {
            this.checkAndFire(this.rootEntry, this.rootEntry.getChildren(), this.listFiles(file));
        } else if (this.rootEntry.isExists()) {
            this.checkAndFire(this.rootEntry, this.rootEntry.getChildren(), FileUtils.EMPTY_FILE_ARRAY);
        }
        this.listeners.forEach(fileAlterationListener -> fileAlterationListener.onStop(this));
    }

    private FileEntry createFileEntry(FileEntry fileEntry, File file) {
        FileEntry fileEntry2 = fileEntry.newChildInstance(file);
        fileEntry2.refresh(file);
        fileEntry2.setChildren(this.listFileEntries(file, fileEntry2));
        return fileEntry2;
    }

    public void destroy() {
    }

    private void fireOnChange(FileEntry fileEntry, File file) {
        if (fileEntry.refresh(file)) {
            this.listeners.forEach(fileAlterationListener -> {
                if (fileEntry.isDirectory()) {
                    fileAlterationListener.onDirectoryChange(file);
                } else {
                    fileAlterationListener.onFileChange(file);
                }
            });
        }
    }

    private void fireOnCreate(FileEntry fileEntry) {
        this.listeners.forEach(fileAlterationListener -> {
            if (fileEntry.isDirectory()) {
                fileAlterationListener.onDirectoryCreate(fileEntry.getFile());
            } else {
                fileAlterationListener.onFileCreate(fileEntry.getFile());
            }
        });
        Stream.of(fileEntry.getChildren()).forEach(this::fireOnCreate);
    }

    private void fireOnDelete(FileEntry fileEntry) {
        this.listeners.forEach(fileAlterationListener -> {
            if (fileEntry.isDirectory()) {
                fileAlterationListener.onDirectoryDelete(fileEntry.getFile());
            } else {
                fileAlterationListener.onFileDelete(fileEntry.getFile());
            }
        });
    }

    Comparator getComparator() {
        return this.comparator;
    }

    public File getDirectory() {
        return this.rootEntry.getFile();
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public Iterable getListeners() {
        return new ArrayList(this.listeners);
    }

    public void initialize() {
        this.rootEntry.refresh(this.rootEntry.getFile());
        this.rootEntry.setChildren(this.listFileEntries(this.rootEntry.getFile(), this.rootEntry));
    }

    private FileEntry[] listFileEntries(File file2, FileEntry fileEntry) {
        return (FileEntry[])Stream.of(this.listFiles(file2)).map(file -> this.createFileEntry(fileEntry, (File)file)).toArray(FileEntry[]::new);
    }

    private File[] listFiles(File file) {
        return file.isDirectory() ? this.sort(file.listFiles(this.fileFilter)) : FileUtils.EMPTY_FILE_ARRAY;
    }

    public void removeListener(FileAlterationListener fileAlterationListener) {
        if (fileAlterationListener != null) {
            this.listeners.removeIf(fileAlterationListener::equals);
        }
    }

    private File[] sort(File[] fileArray) {
        if (fileArray == null) {
            return FileUtils.EMPTY_FILE_ARRAY;
        }
        if (fileArray.length > 1) {
            Arrays.sort(fileArray, this.comparator);
        }
        return fileArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append("[file='");
        stringBuilder.append(this.getDirectory().getPath());
        stringBuilder.append('\'');
        stringBuilder.append(", ");
        stringBuilder.append(this.fileFilter.toString());
        stringBuilder.append(", listeners=");
        stringBuilder.append(this.listeners.size());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    static /* synthetic */ Comparator access$000(IOCase iOCase) {
        return FileAlterationObserver.toComparator(iOCase);
    }

    /* synthetic */ FileAlterationObserver(FileEntry fileEntry, FileFilter fileFilter, Comparator comparator, FileAlterationObserver$1 fileAlterationObserver$1) {
        this(fileEntry, fileFilter, comparator);
    }
}

