/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input.buffer;

import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.io.input.buffer.CircularBufferInputStream;

public class PeekableInputStream
extends CircularBufferInputStream {
    public PeekableInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public PeekableInputStream(InputStream inputStream, int n2) {
        super(inputStream, n2);
    }

    public boolean peek(byte[] byArray) {
        Objects.requireNonNull(byArray, "sourceBuffer");
        return this.peek(byArray, 0, byArray.length);
    }

    public boolean peek(byte[] byArray, int n2, int n3) {
        Objects.requireNonNull(byArray, "sourceBuffer");
        if (byArray.length > this.bufferSize) {
            throw new IllegalArgumentException("Peek request size of " + byArray.length + " bytes exceeds buffer size of " + this.bufferSize + " bytes");
        }
        if (this.buffer.getCurrentNumberOfBytes() < byArray.length) {
            this.fillBuffer();
        }
        return this.buffer.peek(byArray, n2, n3);
    }
}

