/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input.buffer;

import java.util.Objects;
import org.apache.commons.io.IOUtils;

public class CircularByteBuffer {
    private final byte[] buffer;
    private int startOffset;
    private int endOffset;
    private int currentNumberOfBytes;

    public CircularByteBuffer() {
        this(8192);
    }

    public CircularByteBuffer(int n2) {
        this.buffer = IOUtils.byteArray(n2);
        this.startOffset = 0;
        this.endOffset = 0;
        this.currentNumberOfBytes = 0;
    }

    public void add(byte by) {
        if (this.currentNumberOfBytes >= this.buffer.length) {
            throw new IllegalStateException("No space available");
        }
        this.buffer[this.endOffset] = by;
        ++this.currentNumberOfBytes;
        if (++this.endOffset == this.buffer.length) {
            this.endOffset = 0;
        }
    }

    public void add(byte[] byArray, int n2, int n3) {
        Objects.requireNonNull(byArray, "Buffer");
        if (n2 < 0 || n2 >= byArray.length) {
            throw new IllegalArgumentException("Illegal offset: " + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Illegal length: " + n3);
        }
        if (this.currentNumberOfBytes + n3 > this.buffer.length) {
            throw new IllegalStateException("No space available");
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            this.buffer[this.endOffset] = byArray[n2 + i2];
            if (++this.endOffset != this.buffer.length) continue;
            this.endOffset = 0;
        }
        this.currentNumberOfBytes += n3;
    }

    public void clear() {
        this.startOffset = 0;
        this.endOffset = 0;
        this.currentNumberOfBytes = 0;
    }

    public int getCurrentNumberOfBytes() {
        return this.currentNumberOfBytes;
    }

    public int getSpace() {
        return this.buffer.length - this.currentNumberOfBytes;
    }

    public boolean hasBytes() {
        return this.currentNumberOfBytes > 0;
    }

    public boolean hasSpace() {
        return this.currentNumberOfBytes < this.buffer.length;
    }

    public boolean hasSpace(int n2) {
        return this.currentNumberOfBytes + n2 <= this.buffer.length;
    }

    public boolean peek(byte[] byArray, int n2, int n3) {
        Objects.requireNonNull(byArray, "Buffer");
        if (n2 < 0 || n2 >= byArray.length) {
            throw new IllegalArgumentException("Illegal offset: " + n2);
        }
        if (n3 < 0 || n3 > this.buffer.length) {
            throw new IllegalArgumentException("Illegal length: " + n3);
        }
        if (n3 < this.currentNumberOfBytes) {
            return false;
        }
        int n4 = this.startOffset;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.buffer[n4] != byArray[i2 + n2]) {
                return false;
            }
            if (++n4 != this.buffer.length) continue;
            n4 = 0;
        }
        return true;
    }

    public byte read() {
        if (this.currentNumberOfBytes <= 0) {
            throw new IllegalStateException("No bytes available.");
        }
        byte by = this.buffer[this.startOffset];
        --this.currentNumberOfBytes;
        if (++this.startOffset == this.buffer.length) {
            this.startOffset = 0;
        }
        return by;
    }

    public void read(byte[] byArray, int n2, int n3) {
        Objects.requireNonNull(byArray, "targetBuffer");
        if (n2 < 0 || n2 >= byArray.length) {
            throw new IllegalArgumentException("Illegal offset: " + n2);
        }
        if (n3 < 0 || n3 > this.buffer.length) {
            throw new IllegalArgumentException("Illegal length: " + n3);
        }
        if (n2 + n3 > byArray.length) {
            throw new IllegalArgumentException("The supplied byte array contains only " + byArray.length + " bytes, but offset, and length would require " + (n2 + n3 - 1));
        }
        if (this.currentNumberOfBytes < n3) {
            throw new IllegalStateException("Currently, there are only " + this.currentNumberOfBytes + "in the buffer, not " + n3);
        }
        int n4 = n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray[n4++] = this.buffer[this.startOffset];
            --this.currentNumberOfBytes;
            if (++this.startOffset != this.buffer.length) continue;
            this.startOffset = 0;
        }
    }
}

