/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input.buffer;

import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.buffer.CircularByteBuffer;

public class CircularBufferInputStream
extends FilterInputStream {
    protected final CircularByteBuffer buffer;
    protected final int bufferSize;
    private boolean eof;

    public CircularBufferInputStream(InputStream inputStream) {
        this(inputStream, 8192);
    }

    public CircularBufferInputStream(InputStream inputStream, int n2) {
        super(Objects.requireNonNull(inputStream, "inputStream"));
        if (n2 <= 0) {
            throw new IllegalArgumentException("Illegal bufferSize: " + n2);
        }
        this.buffer = new CircularByteBuffer(n2);
        this.bufferSize = n2;
        this.eof = false;
    }

    @Override
    public void close() {
        super.close();
        this.eof = true;
        this.buffer.clear();
    }

    protected void fillBuffer() {
        if (this.eof) {
            return;
        }
        int n2 = this.buffer.getSpace();
        byte[] byArray = IOUtils.byteArray(n2);
        while (n2 > 0) {
            int n3 = this.in.read(byArray, 0, n2);
            if (n3 == -1) {
                this.eof = true;
                return;
            }
            if (n3 <= 0) continue;
            this.buffer.add(byArray, 0, n3);
            n2 -= n3;
        }
    }

    protected boolean haveBytes(int n2) {
        if (this.buffer.getCurrentNumberOfBytes() < n2) {
            this.fillBuffer();
        }
        return this.buffer.hasBytes();
    }

    @Override
    public int read() {
        if (!this.haveBytes(1)) {
            return -1;
        }
        return this.buffer.read() & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        Objects.requireNonNull(byArray, "targetBuffer");
        if (n2 < 0) {
            throw new IllegalArgumentException("Offset must not be negative");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Length must not be negative");
        }
        if (!this.haveBytes(n3)) {
            return -1;
        }
        int n4 = Math.min(n3, this.buffer.getCurrentNumberOfBytes());
        for (int i2 = 0; i2 < n4; ++i2) {
            byArray[n2 + i2] = this.buffer.read();
        }
        return n4;
    }
}

