/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.Reader;
import org.apache.commons.io.input.Input;

public abstract class UnsynchronizedReader
extends Reader {
    private static final int MAX_SKIP_BUFFER_SIZE = 8192;
    private boolean closed;
    private char[] skipBuffer;

    void checkOpen() {
        Input.checkOpen(!this.isClosed());
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean bl2) {
        this.closed = bl2;
    }

    @Override
    public long skip(long l2) {
        long l3;
        int n2;
        if (l2 < 0L) {
            throw new IllegalArgumentException("skip value < 0");
        }
        int n3 = (int)Math.min(l2, 8192L);
        if (this.skipBuffer == null || this.skipBuffer.length < n3) {
            this.skipBuffer = new char[n3];
        }
        for (l3 = l2; l3 > 0L && (n2 = this.read(this.skipBuffer, 0, (int)Math.min(l3, (long)n3))) != -1; l3 -= (long)n2) {
        }
        return l2 - l3;
    }
}

