/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.input.UnsynchronizedReader;

public class UnsynchronizedBufferedReader
extends UnsynchronizedReader {
    private static final char NUL = '\u0000';
    private final Reader in;
    private char[] buf;
    private int pos;
    private int end;
    private int mark = -1;
    private int markLimit = -1;

    public UnsynchronizedBufferedReader(Reader reader) {
        this(reader, 8192);
    }

    public UnsynchronizedBufferedReader(Reader reader, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.in = reader;
        this.buf = new char[n2];
    }

    final void chompNewline() {
        if ((this.pos != this.end || this.fillBuf() != -1) && this.buf[this.pos] == '\n') {
            ++this.pos;
        }
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.in.close();
            this.buf = null;
            super.close();
        }
    }

    private int fillBuf() {
        int n2;
        if (this.mark == -1 || this.pos - this.mark >= this.markLimit) {
            int n3 = this.in.read(this.buf, 0, this.buf.length);
            if (n3 > 0) {
                this.mark = -1;
                this.pos = 0;
                this.end = n3;
            }
            return n3;
        }
        if (this.mark == 0 && this.markLimit > this.buf.length) {
            n2 = this.buf.length * 2;
            if (n2 > this.markLimit) {
                n2 = this.markLimit;
            }
            char[] cArray = new char[n2];
            System.arraycopy(this.buf, 0, cArray, 0, this.buf.length);
            this.buf = cArray;
        } else if (this.mark > 0) {
            System.arraycopy(this.buf, this.mark, this.buf, 0, this.buf.length - this.mark);
            this.pos -= this.mark;
            this.end -= this.mark;
            this.mark = 0;
        }
        n2 = this.in.read(this.buf, this.pos, this.buf.length - this.pos);
        if (n2 != -1) {
            this.end += n2;
        }
        return n2;
    }

    @Override
    public void mark(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.checkOpen();
        this.markLimit = n2;
        this.mark = this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    public int peek() {
        this.mark(1);
        int n2 = this.read();
        this.reset();
        return n2;
    }

    public int peek(char[] cArray) {
        int n2 = cArray.length;
        this.mark(n2);
        int n3 = this.read(cArray, 0, n2);
        this.reset();
        return n3;
    }

    @Override
    public int read() {
        this.checkOpen();
        if (this.pos < this.end || this.fillBuf() != -1) {
            return this.buf[this.pos++];
        }
        return -1;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) {
        int n4;
        this.checkOpen();
        if (n2 < 0 || n2 > cArray.length - n3 || n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n5 = n3;
        while (n5 > 0) {
            int n6;
            n4 = this.end - this.pos;
            if (n4 > 0) {
                n6 = n4 >= n5 ? n5 : n4;
                System.arraycopy(this.buf, this.pos, cArray, n2, n6);
                this.pos += n6;
                n2 += n6;
                n5 -= n6;
            }
            if (n5 == 0 || n5 < n3 && !this.in.ready()) break;
            if ((this.mark == -1 || this.pos - this.mark >= this.markLimit) && n5 >= this.buf.length) {
                n6 = this.in.read(cArray, n2, n5);
                if (n6 <= 0) break;
                n5 -= n6;
                this.mark = -1;
                break;
            }
            if (this.fillBuf() != -1) continue;
            break;
        }
        return (n4 = n3 - n5) > 0 || n4 == n3 ? n4 : -1;
    }

    public String readLine() {
        int n2;
        this.checkOpen();
        if (this.pos == this.end && this.fillBuf() == -1) {
            return null;
        }
        for (n2 = this.pos; n2 < this.end; ++n2) {
            char c2 = this.buf[n2];
            if (c2 > '\r') continue;
            if (c2 == '\n') {
                String string = new String(this.buf, this.pos, n2 - this.pos);
                this.pos = n2 + 1;
                return string;
            }
            if (c2 != '\r') continue;
            String string = new String(this.buf, this.pos, n2 - this.pos);
            this.pos = n2 + 1;
            if ((this.pos < this.end || this.fillBuf() != -1) && this.buf[this.pos] == '\n') {
                ++this.pos;
            }
            return string;
        }
        n2 = 0;
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append(this.buf, this.pos, this.end - this.pos);
        while (true) {
            this.pos = this.end;
            if (n2 == 10) {
                return stringBuilder.toString();
            }
            if (this.fillBuf() == -1) {
                return stringBuilder.length() > 0 || n2 != 0 ? stringBuilder.toString() : null;
            }
            for (int i2 = this.pos; i2 < this.end; ++i2) {
                int n3 = this.buf[i2];
                if (n2 != 0) {
                    if (n2 == 13 && n3 == 10) {
                        if (i2 > this.pos) {
                            stringBuilder.append(this.buf, this.pos, i2 - this.pos - 1);
                        }
                        this.pos = i2 + 1;
                    } else {
                        if (i2 > this.pos) {
                            stringBuilder.append(this.buf, this.pos, i2 - this.pos - 1);
                        }
                        this.pos = i2;
                    }
                    return stringBuilder.toString();
                }
                if (n3 != 10 && n3 != 13) continue;
                n2 = n3;
            }
            if (n2 == 0) {
                stringBuilder.append(this.buf, this.pos, this.end - this.pos);
                continue;
            }
            stringBuilder.append(this.buf, this.pos, this.end - this.pos - 1);
        }
    }

    @Override
    public boolean ready() {
        this.checkOpen();
        return this.end - this.pos > 0 || this.in.ready();
    }

    @Override
    public void reset() {
        this.checkOpen();
        if (this.mark == -1) {
            throw new IOException("mark == -1");
        }
        this.pos = this.mark;
    }

    @Override
    public long skip(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException();
        }
        this.checkOpen();
        if (l2 < 1L) {
            return 0L;
        }
        if ((long)(this.end - this.pos) >= l2) {
            this.pos += Math.toIntExact(l2);
            return l2;
        }
        this.pos = this.end;
        for (long i2 = (long)(this.end - this.pos); i2 < l2; i2 += (long)(this.end - this.pos)) {
            if (this.fillBuf() == -1) {
                return i2;
            }
            if ((long)(this.end - this.pos) >= l2 - i2) {
                this.pos += Math.toIntExact(l2 - i2);
                return l2;
            }
            this.pos = this.end;
        }
        return l2;
    }
}

