/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.UnsynchronizedFilterInputStream;

public final class UnsynchronizedBufferedInputStream
extends UnsynchronizedFilterInputStream {
    protected volatile byte[] buffer;
    protected int count;
    protected int markLimit;
    protected int markPos = -1;
    protected int pos;

    private UnsynchronizedBufferedInputStream(InputStream inputStream, int n2) {
        super(inputStream);
        if (n2 <= 0) {
            throw new IllegalArgumentException("Size must be > 0");
        }
        this.buffer = new byte[n2];
    }

    @Override
    public int available() {
        InputStream inputStream = this.inputStream;
        if (this.buffer == null || inputStream == null) {
            throw new IOException("Stream is closed");
        }
        return this.count - this.pos + inputStream.available();
    }

    @Override
    public void close() {
        this.buffer = null;
        InputStream inputStream = this.inputStream;
        this.inputStream = null;
        if (inputStream != null) {
            inputStream.close();
        }
    }

    private int fillBuffer(InputStream inputStream, byte[] byArray) {
        int n2;
        if (this.markPos == -1 || this.pos - this.markPos >= this.markLimit) {
            int n3 = inputStream.read(byArray);
            if (n3 > 0) {
                this.markPos = -1;
                this.pos = 0;
                this.count = n3;
            }
            return n3;
        }
        if (this.markPos == 0 && this.markLimit > byArray.length) {
            n2 = byArray.length * 2;
            if (n2 > this.markLimit) {
                n2 = this.markLimit;
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.buffer = byArray2;
            byArray = byArray2;
        } else if (this.markPos > 0) {
            System.arraycopy(byArray, this.markPos, byArray, 0, byArray.length - this.markPos);
        }
        this.pos -= this.markPos;
        this.markPos = 0;
        this.count = 0;
        n2 = inputStream.read(byArray, this.pos, byArray.length - this.pos);
        this.count = n2 <= 0 ? this.pos : this.pos + n2;
        return n2;
    }

    byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public void mark(int n2) {
        this.markLimit = n2;
        this.markPos = this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        byte[] byArray = this.buffer;
        InputStream inputStream = this.inputStream;
        if (byArray == null || inputStream == null) {
            throw new IOException("Stream is closed");
        }
        if (this.pos >= this.count && this.fillBuffer(inputStream, byArray) == -1) {
            return -1;
        }
        if (byArray != this.buffer && (byArray = this.buffer) == null) {
            throw new IOException("Stream is closed");
        }
        if (this.count - this.pos > 0) {
            return byArray[this.pos++] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        byte[] byArray2 = this.buffer;
        if (byArray2 == null) {
            throw new IOException("Stream is closed");
        }
        if (n2 > byArray.length - n3 || n2 < 0 || n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        InputStream inputStream = this.inputStream;
        if (inputStream == null) {
            throw new IOException("Stream is closed");
        }
        if (this.pos < this.count) {
            n5 = this.count - this.pos >= n3 ? n3 : this.count - this.pos;
            System.arraycopy(byArray2, this.pos, byArray, n2, n5);
            this.pos += n5;
            if (n5 == n3 || inputStream.available() == 0) {
                return n5;
            }
            n2 += n5;
            n4 = n3 - n5;
        } else {
            n4 = n3;
        }
        while (true) {
            if (this.markPos == -1 && n4 >= byArray2.length) {
                n5 = inputStream.read(byArray, n2, n4);
                if (n5 == -1) {
                    return n4 == n3 ? -1 : n3 - n4;
                }
            } else {
                if (this.fillBuffer(inputStream, byArray2) == -1) {
                    return n4 == n3 ? -1 : n3 - n4;
                }
                if (byArray2 != this.buffer && (byArray2 = this.buffer) == null) {
                    throw new IOException("Stream is closed");
                }
                n5 = this.count - this.pos >= n4 ? n4 : this.count - this.pos;
                System.arraycopy(byArray2, this.pos, byArray, n2, n5);
                this.pos += n5;
            }
            if ((n4 -= n5) == 0) {
                return n3;
            }
            if (inputStream.available() == 0) {
                return n3 - n4;
            }
            n2 += n5;
        }
    }

    @Override
    public void reset() {
        if (this.buffer == null) {
            throw new IOException("Stream is closed");
        }
        if (-1 == this.markPos) {
            throw new IOException("Mark has been invalidated");
        }
        this.pos = this.markPos;
    }

    @Override
    public long skip(long l2) {
        byte[] byArray = this.buffer;
        InputStream inputStream = this.inputStream;
        if (byArray == null) {
            throw new IOException("Stream is closed");
        }
        if (l2 < 1L) {
            return 0L;
        }
        if (inputStream == null) {
            throw new IOException("Stream is closed");
        }
        if ((long)(this.count - this.pos) >= l2) {
            this.pos += (int)l2;
            return l2;
        }
        int n2 = this.count - this.pos;
        this.pos = this.count;
        if (this.markPos != -1 && l2 <= (long)this.markLimit) {
            if (this.fillBuffer(inputStream, byArray) == -1) {
                return n2;
            }
            if ((long)(this.count - this.pos) >= l2 - (long)n2) {
                this.pos += (int)l2 - n2;
                return l2;
            }
            this.pos = this.count;
            return n2 += this.count - this.pos;
        }
        return (long)n2 + inputStream.skip(l2 - (long)n2);
    }
}

