/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.InputStream;
import org.apache.commons.io.input.UnsupportedOperationExceptions;

public class UnixLineEndingInputStream
extends InputStream {
    private boolean atEos;
    private boolean atSlashCr;
    private boolean atSlashLf;
    private final InputStream in;
    private final boolean lineFeedAtEndOfFile;

    public UnixLineEndingInputStream(InputStream inputStream, boolean bl2) {
        this.in = inputStream;
        this.lineFeedAtEndOfFile = bl2;
    }

    @Override
    public void close() {
        super.close();
        this.in.close();
    }

    private int handleEos(boolean bl2) {
        if (bl2 || !this.lineFeedAtEndOfFile) {
            return -1;
        }
        if (!this.atSlashLf) {
            this.atSlashLf = true;
            return 10;
        }
        return -1;
    }

    @Override
    public synchronized void mark(int n2) {
        throw UnsupportedOperationExceptions.mark();
    }

    @Override
    public int read() {
        boolean bl2 = this.atSlashCr;
        if (this.atEos) {
            return this.handleEos(bl2);
        }
        int n2 = this.readWithUpdate();
        if (this.atEos) {
            return this.handleEos(bl2);
        }
        if (this.atSlashCr) {
            return 10;
        }
        if (bl2 && this.atSlashLf) {
            return this.read();
        }
        return n2;
    }

    private int readWithUpdate() {
        int n2 = this.in.read();
        boolean bl2 = this.atEos = n2 == -1;
        if (this.atEos) {
            return n2;
        }
        this.atSlashCr = n2 == 13;
        this.atSlashLf = n2 == 10;
        return n2;
    }
}

