/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.InterruptedIOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.io.input.ThrottledInputStream$Builder;

public final class ThrottledInputStream
extends CountingInputStream {
    private final long maxBytesPerSecond;
    private final long startTime = System.currentTimeMillis();
    private Duration totalSleepDuration = Duration.ZERO;

    public static ThrottledInputStream$Builder builder() {
        return new ThrottledInputStream$Builder();
    }

    static long toSleepMillis(long l2, long l3, long l4) {
        if (l4 < 0L) {
            throw new IllegalArgumentException("The elapsed time should be greater or equal to zero");
        }
        if (l2 <= 0L || l3 <= 0L || l4 == 0L) {
            return 0L;
        }
        long l5 = (long)((double)l2 / (double)l3 * 1000.0 - (double)l4);
        if (l5 <= 0L) {
            return 0L;
        }
        return l5;
    }

    private ThrottledInputStream(ThrottledInputStream$Builder throttledInputStream$Builder) {
        super(throttledInputStream$Builder);
        if (ThrottledInputStream$Builder.access$100(throttledInputStream$Builder) <= 0L) {
            throw new IllegalArgumentException("Bandwidth " + ThrottledInputStream$Builder.access$100(throttledInputStream$Builder) + " is invalid.");
        }
        this.maxBytesPerSecond = ThrottledInputStream$Builder.access$100(throttledInputStream$Builder);
    }

    @Override
    protected void beforeRead(int n2) {
        this.throttle();
    }

    private long getBytesPerSecond() {
        long l2 = (System.currentTimeMillis() - this.startTime) / 1000L;
        if (l2 == 0L) {
            return this.getByteCount();
        }
        return this.getByteCount() / l2;
    }

    private long getSleepMillis() {
        return ThrottledInputStream.toSleepMillis(this.getByteCount(), this.maxBytesPerSecond, System.currentTimeMillis() - this.startTime);
    }

    Duration getTotalSleepDuration() {
        return this.totalSleepDuration;
    }

    private void throttle() {
        long l2 = this.getSleepMillis();
        if (l2 > 0L) {
            this.totalSleepDuration = this.totalSleepDuration.plus(l2, ChronoUnit.MILLIS);
            try {
                TimeUnit.MILLISECONDS.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException("Thread aborted");
            }
        }
    }

    public String toString() {
        return "ThrottledInputStream[bytesRead=" + this.getByteCount() + ", maxBytesPerSec=" + this.maxBytesPerSecond + ", bytesPerSec=" + this.getBytesPerSecond() + ", totalSleepDuration=" + this.totalSleepDuration + ']';
    }
}

