/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import org.apache.commons.io.input.ProxyReader;

public class TeeReader
extends ProxyReader {
    private final Writer branch;
    private final boolean closeBranch;

    public TeeReader(Reader reader, Writer writer) {
        this(reader, writer, false);
    }

    public TeeReader(Reader reader, Writer writer, boolean bl2) {
        super(reader);
        this.branch = writer;
        this.closeBranch = bl2;
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            if (this.closeBranch) {
                this.branch.close();
            }
        }
    }

    @Override
    public int read() {
        int n2 = super.read();
        if (n2 != -1) {
            this.branch.write(n2);
        }
        return n2;
    }

    @Override
    public int read(char[] cArray) {
        int n2 = super.read(cArray);
        if (n2 != -1) {
            this.branch.write(cArray, 0, n2);
        }
        return n2;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) {
        int n4 = super.read(cArray, n2, n3);
        if (n4 != -1) {
            this.branch.write(cArray, n2, n4);
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(CharBuffer charBuffer) {
        int n2 = charBuffer.position();
        int n3 = super.read(charBuffer);
        if (n3 != -1) {
            int n4 = charBuffer.position();
            int n5 = charBuffer.limit();
            try {
                charBuffer.position(n2).limit(n4);
                this.branch.append(charBuffer);
            }
            finally {
                charBuffer.position(n4).limit(n5);
            }
        }
        return n3;
    }
}

