/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.input.Tailer$1;
import org.apache.commons.io.input.Tailer$RandomAccessFileBridge;
import org.apache.commons.io.input.Tailer$RandomAccessResourceBridge;
import org.apache.commons.io.input.Tailer$Tailable;

final class Tailer$TailablePath
implements Tailer$Tailable {
    private final Path path;
    private final LinkOption[] linkOptions;

    private Tailer$TailablePath(Path path, LinkOption ... linkOptionArray) {
        this.path = Objects.requireNonNull(path, "path");
        this.linkOptions = linkOptionArray;
    }

    Path getPath() {
        return this.path;
    }

    @Override
    public Tailer$RandomAccessResourceBridge getRandomAccess(String string) {
        return new Tailer$RandomAccessFileBridge(this.path.toFile(), string);
    }

    @Override
    public boolean isNewer(FileTime fileTime) {
        return PathUtils.isNewer(this.path, fileTime, this.linkOptions);
    }

    @Override
    public FileTime lastModifiedFileTime() {
        return Files.getLastModifiedTime(this.path, this.linkOptions);
    }

    @Override
    public long size() {
        return Files.size(this.path);
    }

    public String toString() {
        return "TailablePath [file=" + this.path + ", linkOptions=" + Arrays.toString(this.linkOptions) + "]";
    }

    /* synthetic */ Tailer$TailablePath(Path path, LinkOption[] linkOptionArray, Tailer$1 tailer$1) {
        this(path, linkOptionArray);
    }
}

