/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.nio.file.LinkOption;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.build.AbstractOrigin;
import org.apache.commons.io.build.AbstractStreamBuilder;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.Tailer$Tailable;
import org.apache.commons.io.input.Tailer$TailablePath;
import org.apache.commons.io.input.TailerListener;

public class Tailer$Builder
extends AbstractStreamBuilder {
    private static final Duration DEFAULT_DELAY_DURATION = Duration.ofMillis(1000L);
    private Tailer$Tailable tailable;
    private TailerListener tailerListener;
    private Duration delayDuration = DEFAULT_DELAY_DURATION;
    private boolean tailFromEnd;
    private boolean reOpen;
    private boolean startThread = true;
    private ExecutorService executorService = Executors.newSingleThreadExecutor(Tailer$Builder::newDaemonThread);

    private static Thread newDaemonThread(Runnable runnable) {
        Thread thread = new Thread(runnable, "commons-io-tailer");
        thread.setDaemon(true);
        return thread;
    }

    @Override
    public Tailer get() {
        Tailer tailer = new Tailer(this.tailable, this.getCharset(), this.tailerListener, this.delayDuration, this.tailFromEnd, this.reOpen, this.getBufferSize(), null);
        if (this.startThread) {
            this.executorService.submit(tailer);
        }
        return tailer;
    }

    public Tailer$Builder setDelayDuration(Duration duration) {
        this.delayDuration = duration != null ? duration : DEFAULT_DELAY_DURATION;
        return this;
    }

    public Tailer$Builder setExecutorService(ExecutorService executorService) {
        this.executorService = Objects.requireNonNull(executorService, "executorService");
        return this;
    }

    @Override
    protected Tailer$Builder setOrigin(AbstractOrigin abstractOrigin) {
        this.setTailable(new Tailer$TailablePath(abstractOrigin.getPath(), new LinkOption[0], null));
        return (Tailer$Builder)super.setOrigin(abstractOrigin);
    }

    public Tailer$Builder setReOpen(boolean bl2) {
        this.reOpen = bl2;
        return this;
    }

    public Tailer$Builder setStartThread(boolean bl2) {
        this.startThread = bl2;
        return this;
    }

    public Tailer$Builder setTailable(Tailer$Tailable tailer$Tailable) {
        this.tailable = Objects.requireNonNull(tailer$Tailable, "tailable");
        return this;
    }

    public Tailer$Builder setTailerListener(TailerListener tailerListener) {
        this.tailerListener = Objects.requireNonNull(tailerListener, "tailerListener");
        return this;
    }

    public Tailer$Builder setTailFromEnd(boolean bl2) {
        this.tailFromEnd = bl2;
        return this;
    }
}

